package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.ClassTeam;
import com.ptteng.common.skill.service.ClassTeamService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ClassTeamServiceImpl extends BaseDaoServiceImpl implements ClassTeamService {


    private static final Log log = LogFactory.getLog(ClassTeamServiceImpl.class);


    @Override
    public Long insert(ClassTeam classTeam) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + classTeam);

        if (classTeam == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        classTeam.setCreateAt(currentTimeMillis);
        classTeam.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(classTeam);
        } catch (DaoException e) {
            log.error(" insert wrong : " + classTeam);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<ClassTeam> insertList(List<ClassTeam> classTeamList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (classTeamList == null ? "null" : classTeamList.size()));

        List<ClassTeam> resultList = null;

        if (CollectionUtils.isEmpty(classTeamList)) {
            return new ArrayList<ClassTeam>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (ClassTeam classTeam : classTeamList) {
            classTeam.setCreateAt(currentTimeMillis);
            classTeam.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<ClassTeam>) dao.batchSave(classTeamList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + classTeamList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(ClassTeam.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(ClassTeam classTeam) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (classTeam == null ? "null" : classTeam.getId()));

        boolean result = false;

        if (classTeam == null) {
            return true;
        }

        classTeam.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(classTeam);
        } catch (DaoException e) {
            log.error(" update wrong : " + classTeam);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + classTeam);
        }
        return result;
    }


    @Override
    public boolean updateList(List<ClassTeam> classTeamList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (classTeamList == null ? "null" : classTeamList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(classTeamList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (ClassTeam classTeam : classTeamList) {
            classTeam.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(classTeamList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + classTeamList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + classTeamList.size());

        return result;
    }


    @Override
    public ClassTeam getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        ClassTeam classTeam = null;

        if (id == null) {
            return classTeam;
        }

        try {
            classTeam = (ClassTeam) dao.get(ClassTeam.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return classTeam;
    }


    @Override
    public List<ClassTeam> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<ClassTeam> classTeam = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ClassTeam>();
        }

        try {
            classTeam = (List<ClassTeam>) dao.getList(ClassTeam.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (classTeam == null ? "null" : classTeam.size()));

        return classTeam;
    }


    @Override
    public List<Long> getClassTeamIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getClassTeamIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countClassTeamIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getClassTeamIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getClassTeamIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

