package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Advisory;
import com.ptteng.common.skill.service.AdvisoryService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class AdvisoryServiceImpl extends BaseDaoServiceImpl implements AdvisoryService {

 

	private static final Log log = LogFactory.getLog(AdvisoryServiceImpl.class);



		   
		@Override
		public Long insert(Advisory advisory)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + advisory);

		if (advisory == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		advisory.setCreateAt(currentTimeMillis);
		advisory.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(advisory);
		} catch (DaoException e) {
			log.error(" insert wrong : " + advisory);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Advisory> insertList(List<Advisory> advisoryList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (advisoryList == null ? "null" : advisoryList.size()));
      
		List<Advisory> resultList = null;

		if (CollectionUtils.isEmpty(advisoryList)) {
			return new ArrayList<Advisory>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Advisory advisory : advisoryList) {
			advisory.setCreateAt(currentTimeMillis);
			advisory.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Advisory>) dao.batchSave(advisoryList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + advisoryList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Advisory.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Advisory advisory)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (advisory == null ? "null" : advisory.getId()));

		boolean result = false;

		if (advisory == null) {
			return true;
		}

		advisory.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(advisory);
		} catch (DaoException e) {
			log.error(" update wrong : " + advisory);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + advisory);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Advisory> advisoryList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (advisoryList == null ? "null" : advisoryList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(advisoryList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Advisory advisory : advisoryList) {
			advisory.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(advisoryList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + advisoryList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + advisoryList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Advisory getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Advisory advisory = null;

		if (id == null) {
			return advisory;
		}

		try {
			advisory = (Advisory) dao.get(Advisory.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return advisory;		
		}	
		  
    	   
		@Override
		public List<Advisory> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Advisory> advisory = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Advisory>();
		}

		try {
			advisory = (List<Advisory>) dao.getList(Advisory.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (advisory == null ? "null" : advisory.size()));
    
		return advisory;	
		}






	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Long  getAdvisoryIdByOid(Long oid)throws ServiceException, ServiceDaoException {

		if (log.isInfoEnabled()) {
			log.info(" get id by oid  : " + oid);
		}
		Long id = null;

		// TODO 参数检查!

		try {


			id = (Long) dao.getMapping("getAdvisoryIdByOid", new Object[]{oid});
		} catch (DaoException e) {
			log.error(" get id wrong by oid  : " + oid);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get id success : " + id);
		}
		return id;
	}






		@Override
	public List<Long> getAdvisoryIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getAdvisoryIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countAdvisoryIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getAdvisoryIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getAdvisoryIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

