/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.UserStatistics;
import com.ptteng.common.skill.service.UserStatisticsService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserStatisticsServiceImpl
extends BaseDaoServiceImpl
implements UserStatisticsService {
    private static final Log log = LogFactory.getLog(UserStatisticsServiceImpl.class);

    public Long insert(UserStatistics userStatistics) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userStatistics));
        if (userStatistics == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userStatistics.setCreateAt(Long.valueOf(currentTimeMillis));
        userStatistics.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userStatistics);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userStatistics));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserStatistics> insertList(List<UserStatistics> userStatisticsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userStatisticsList == null ? "null" : Integer.valueOf(userStatisticsList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userStatisticsList)) {
            return new ArrayList<UserStatistics>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserStatistics userStatistics : userStatisticsList) {
            userStatistics.setCreateAt(Long.valueOf(currentTimeMillis));
            userStatistics.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userStatisticsList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userStatisticsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserStatistics.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserStatistics userStatistics) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userStatistics == null ? "null" : userStatistics.getId())));
        boolean result = false;
        if (userStatistics == null) {
            return true;
        }
        userStatistics.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userStatistics);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userStatistics));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userStatistics));
        }
        return result;
    }

    public boolean updateList(List<UserStatistics> userStatisticsList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userStatisticsList == null ? "null" : Integer.valueOf(userStatisticsList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userStatisticsList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserStatistics userStatistics : userStatisticsList) {
            userStatistics.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userStatisticsList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userStatisticsList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userStatisticsList.size()));
        return result;
    }

    public UserStatistics getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserStatistics userStatistics = null;
        if (id == null) {
            return userStatistics;
        }
        try {
            userStatistics = (UserStatistics)this.dao.get(UserStatistics.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userStatistics;
    }

    public List<UserStatistics> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userStatistics = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserStatistics>();
        }
        try {
            userStatistics = this.dao.getList(UserStatistics.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userStatistics == null ? "null" : Integer.valueOf(userStatistics.size()))));
        return userStatistics;
    }

    public List<Long> getUserStatisticsIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserStatisticsIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserStatisticsIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserStatisticsIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserStatisticsIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

