CREATE TABLE `class_timetable` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `arrange_date` bigint(20) NOT NULL   COMMENT '排课日期',
    `subject_id` bigint(20) NOT NULL   COMMENT '课题id',
    `class_team_id` bigint(20) NOT NULL   COMMENT '课堂小组id',
    `teach_uid` bigint(20) NOT NULL   COMMENT '讲课人ID',
    `speak_status` int(2) DEFAULT 0 COMMENT '课程状态  1：预告 2：未审核 3：未评级 4：已评级',
    `publish_state`  int(2) NOT NULL DEFAULT 0 COMMENT '课堂发布状态：1：未发布  2：已发布',
    `level` int(2) NULL DEFAULT 0 COMMENT '评级  1:下品 2:中品 3:上品',
    `comment` text   COMMENT '评语',
    `status` int(2) NULL DEFAULT 0  COMMENT '上下架(精选)状态   0：下架 1：上架 2:课表被删除后的状态（课表删除后，不影响小课堂的展示）',
    `leave_uid` varchar(300)    COMMENT '请假人id数组',
    `absent_uid` varchar(300)    COMMENT '旷课人id数组',
    `group_user_count`  int(4) NULL DEFAULT 0 COMMENT '小组总人数',
    `collection` int(10) NULL DEFAULT 0    COMMENT '收藏数',
    `love` int(10) NULL DEFAULT 0    COMMENT '点赞数',
    `read_count` int(10) NULL DEFAULT 0    COMMENT '收藏数',
    `comment_count`  int(10) NULL DEFAULT 0 COMMENT '评论数',
    `ppt_url` text    COMMENT 'ppt链接',
    `video_url` text    COMMENT '视频链接',
    `content` text    COMMENT '讲课内容',
    `target_people` varchar(40)    COMMENT '目标人群',
    `expect` varchar(200)    COMMENT '课堂期望',
    `class_abstract` varchar(200)    COMMENT '课堂简介',
    `preview_img` text    COMMENT '预告图片',
    `create_by` bigint(20) NOT NULL   COMMENT '',
    `update_by` bigint(20)    COMMENT '',
    `update_at` bigint(20) NOT NULL   COMMENT '',
    `create_at` bigint(20) NOT NULL   COMMENT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;
