/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Week;
import com.ptteng.common.skill.service.WeekService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WeekServiceImpl
extends BaseDaoServiceImpl
implements WeekService {
    private static final Log log = LogFactory.getLog(WeekServiceImpl.class);

    public Long insert(Week week) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + week));
        if (week == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        week.setCreateAt(Long.valueOf(currentTimeMillis));
        week.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)week);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + week));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Week> insertList(List<Week> weekList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (weekList == null ? "null" : Integer.valueOf(weekList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(weekList)) {
            return new ArrayList<Week>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Week week : weekList) {
            week.setCreateAt(Long.valueOf(currentTimeMillis));
            week.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(weekList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + weekList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Week.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Week week) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (week == null ? "null" : week.getId())));
        boolean result = false;
        if (week == null) {
            return true;
        }
        week.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)week);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + week));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + week));
        }
        return result;
    }

    public boolean updateList(List<Week> weekList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (weekList == null ? "null" : Integer.valueOf(weekList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(weekList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Week week : weekList) {
            week.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(weekList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + weekList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + weekList.size()));
        return result;
    }

    public Week getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Week week = null;
        if (id == null) {
            return week;
        }
        try {
            week = (Week)this.dao.get(Week.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return week;
    }

    public List<Week> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List week = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Week>();
        }
        try {
            week = this.dao.getList(Week.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (week == null ? "null" : Integer.valueOf(week.size()))));
        return week;
    }

    public List<Long> getWeekIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getWeekIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countWeekIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getWeekIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getWeekIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getWeekIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countWeekIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getWeekIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getWeekIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

