package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.UserStatistics;
import com.ptteng.common.skill.service.UserStatisticsService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserStatisticsServiceImpl extends BaseDaoServiceImpl implements UserStatisticsService {

 

	private static final Log log = LogFactory.getLog(UserStatisticsServiceImpl.class);



		   
		@Override
		public Long insert(UserStatistics userStatistics)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userStatistics);

		if (userStatistics == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userStatistics.setCreateAt(currentTimeMillis);
		userStatistics.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userStatistics);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userStatistics);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserStatistics> insertList(List<UserStatistics> userStatisticsList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userStatisticsList == null ? "null" : userStatisticsList.size()));
      
		List<UserStatistics> resultList = null;

		if (CollectionUtils.isEmpty(userStatisticsList)) {
			return new ArrayList<UserStatistics>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserStatistics userStatistics : userStatisticsList) {
			userStatistics.setCreateAt(currentTimeMillis);
			userStatistics.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserStatistics>) dao.batchSave(userStatisticsList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userStatisticsList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserStatistics.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserStatistics userStatistics)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userStatistics == null ? "null" : userStatistics.getId()));

		boolean result = false;

		if (userStatistics == null) {
			return true;
		}

		userStatistics.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userStatistics);
		} catch (DaoException e) {
			log.error(" update wrong : " + userStatistics);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userStatistics);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserStatistics> userStatisticsList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userStatisticsList == null ? "null" : userStatisticsList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userStatisticsList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserStatistics userStatistics : userStatisticsList) {
			userStatistics.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userStatisticsList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userStatisticsList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userStatisticsList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserStatistics getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserStatistics userStatistics = null;

		if (id == null) {
			return userStatistics;
		}

		try {
			userStatistics = (UserStatistics) dao.get(UserStatistics.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userStatistics;		
		}	
		  
    	   
		@Override
		public List<UserStatistics> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserStatistics> userStatistics = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserStatistics>();
		}

		try {
			userStatistics = (List<UserStatistics>) dao.getList(UserStatistics.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userStatistics == null ? "null" : userStatistics.size()));
    
		return userStatistics;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getUserStatisticsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserStatisticsIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserStatisticsIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserStatisticsIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserStatisticsIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

