package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Stype;
import com.ptteng.common.skill.service.StypeService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class StypeServiceImpl extends BaseDaoServiceImpl implements StypeService {

 

	private static final Log log = LogFactory.getLog(StypeServiceImpl.class);



		   
		@Override
		public Long insert(Stype stype)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + stype);

		if (stype == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		stype.setCreateAt(currentTimeMillis);
		stype.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(stype);
		} catch (DaoException e) {
			log.error(" insert wrong : " + stype);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Stype> insertList(List<Stype> stypeList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (stypeList == null ? "null" : stypeList.size()));
      
		List<Stype> resultList = null;

		if (CollectionUtils.isEmpty(stypeList)) {
			return new ArrayList<Stype>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Stype stype : stypeList) {
			stype.setCreateAt(currentTimeMillis);
			stype.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Stype>) dao.batchSave(stypeList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + stypeList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Stype.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Stype stype)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (stype == null ? "null" : stype.getId()));

		boolean result = false;

		if (stype == null) {
			return true;
		}

		stype.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(stype);
		} catch (DaoException e) {
			log.error(" update wrong : " + stype);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + stype);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Stype> stypeList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (stypeList == null ? "null" : stypeList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(stypeList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Stype stype : stypeList) {
			stype.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(stypeList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + stypeList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + stypeList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Stype getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Stype stype = null;

		if (id == null) {
			return stype;
		}

		try {
			stype = (Stype) dao.get(Stype.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return stype;		
		}	
		  
    	   
		@Override
		public List<Stype> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Stype> stype = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Stype>();
		}

		try {
			stype = (List<Stype>) dao.getList(Stype.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (stype == null ? "null" : stype.size()));
    
		return stype;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getStypeIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getStypeIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countStypeIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getStypeIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getStypeIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

