package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Project;
import com.ptteng.common.skill.service.ProjectService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ProjectServiceImpl extends BaseDaoServiceImpl implements ProjectService {

 

	private static final Log log = LogFactory.getLog(ProjectServiceImpl.class);



		   
		@Override
		public Long insert(Project project)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + project);

		if (project == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		project.setCreateAt(currentTimeMillis);
		project.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(project);
		} catch (DaoException e) {
			log.error(" insert wrong : " + project);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Project> insertList(List<Project> projectList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (projectList == null ? "null" : projectList.size()));
      
		List<Project> resultList = null;

		if (CollectionUtils.isEmpty(projectList)) {
			return new ArrayList<Project>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Project project : projectList) {
			project.setCreateAt(currentTimeMillis);
			project.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Project>) dao.batchSave(projectList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + projectList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Project.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Project project)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (project == null ? "null" : project.getId()));

		boolean result = false;

		if (project == null) {
			return true;
		}

		project.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(project);
		} catch (DaoException e) {
			log.error(" update wrong : " + project);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + project);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Project> projectList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (projectList == null ? "null" : projectList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(projectList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Project project : projectList) {
			project.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(projectList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + projectList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + projectList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Project getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Project project = null;

		if (id == null) {
			return project;
		}

		try {
			project = (Project) dao.get(Project.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return project;		
		}	
		  
    	   
		@Override
		public List<Project> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Project> project = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Project>();
		}

		try {
			project = (List<Project>) dao.getList(Project.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (project == null ? "null" : project.size()));
    
		return project;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProjectIdsByIterationIdOrderByCreateAt(Long iterationId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by iterationId,start,limit  : " + iterationId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getProjectIdsByIterationIdOrderByCreateAt", new Object[] { iterationId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by iterationId,start,limit)  : " + iterationId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
//	 @Override
	public List<Long>  getProjectIdsByTidAndStatusOrderByCreateAt(Long tid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by tid,status,start,limit  : " + tid+" , "+status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getProjectIdsByTidAndStatusOrderByCreateAt", new Object[] { tid,status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by tid,status,start,limit)  : " + tid+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProjectIdsByTidOrderByCreateAt(Long tid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by tid,start,limit  : " + tid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getProjectIdsByTidOrderByCreateAt", new Object[] { tid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by tid,start,limit)  : " + tid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getProjectIdsByNameOrderByCreateAt(String name,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by name,start,limit  : " + name+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getProjectIdsByNameOrderByCreateAt", new Object[] { name},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by name,start,limit)  : " + name+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProjectIdsByIterationIdOrderByCreateAt(Long iterationId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by iterationId  : " + iterationId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getProjectIdsByIterationIdOrderByCreateAt", new Object[] { iterationId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by iterationId)  : " + iterationId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
//	 @Override
	public Integer  countProjectIdsByTidAndStatusOrderByCreateAt(Long tid,Integer status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by tid,status  : " + tid+" , "+status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getProjectIdsByTidAndStatusOrderByCreateAt", new Object[] { tid,status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by tid,status)  : " + tid+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProjectIdsByTidOrderByCreateAt(Long tid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by tid  : " + tid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getProjectIdsByTidOrderByCreateAt", new Object[] { tid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by tid)  : " + tid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countProjectIdsByNameOrderByCreateAt(String name)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by name  : " + name );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getProjectIdsByNameOrderByCreateAt", new Object[] { name});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by name)  : " + name );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getProjectIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getProjectIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countProjectIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getProjectIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getProjectIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

