/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Task;
import com.ptteng.common.skill.service.TaskService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TaskServiceImpl
extends BaseDaoServiceImpl
implements TaskService {
    private static final Log log = LogFactory.getLog(TaskServiceImpl.class);

    public Long insert(Task task) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + task));
        if (task == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        task.setCreateAt(Long.valueOf(currentTimeMillis));
        task.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)task);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + task));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Task> insertList(List<Task> taskList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (taskList == null ? "null" : Integer.valueOf(taskList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(taskList)) {
            return new ArrayList<Task>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Task task : taskList) {
            task.setCreateAt(Long.valueOf(currentTimeMillis));
            task.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(taskList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + taskList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Task.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Task task) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (task == null ? "null" : task.getId())));
        boolean result = false;
        if (task == null) {
            return true;
        }
        task.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)task);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + task));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + task));
        }
        return result;
    }

    public boolean updateList(List<Task> taskList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (taskList == null ? "null" : Integer.valueOf(taskList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(taskList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Task task : taskList) {
            task.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(taskList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + taskList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + taskList.size()));
        return result;
    }

    public Task getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Task task = null;
        if (id == null) {
            return task;
        }
        try {
            task = (Task)this.dao.get(Task.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return task;
    }

    public List<Task> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List task = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Task>();
        }
        try {
            task = this.dao.getList(Task.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (task == null ? "null" : Integer.valueOf(task.size()))));
        return task;
    }

    public List<Long> getTaskIdsByOid(Long oid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by oid  : " + oid));
        }
        List idList = null;
        try {
            idList = this.dao.getIdList("getTaskIdsByOid", new Object[]{oid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids wrong by oid  : " + oid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + idList));
        }
        return idList;
    }

    public List<Long> getTaskIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTaskIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTaskIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getTaskIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getTaskIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Integer countTaskIdsByOid(Long oid) throws ServiceException, ServiceDaoException {
        Integer count = 0;
        log.info((Object)"get the count");
        try {
            count = this.dao.count("countTaskIdsByOid", new Object[]{oid});
        }
        catch (DaoException e) {
            log.error((Object)" count by getTaskIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

