/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Provinces;
import com.ptteng.common.skill.service.ProvincesService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProvincesServiceImpl
extends BaseDaoServiceImpl
implements ProvincesService {
    private static final Log log = LogFactory.getLog(ProvincesServiceImpl.class);

    public Long insert(Provinces provinces) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + provinces));
        if (provinces == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        provinces.setCreateAt(Long.valueOf(currentTimeMillis));
        provinces.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)provinces);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + provinces));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Provinces> insertList(List<Provinces> provincesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (provincesList == null ? "null" : Integer.valueOf(provincesList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(provincesList)) {
            return new ArrayList<Provinces>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Provinces provinces : provincesList) {
            provinces.setCreateAt(Long.valueOf(currentTimeMillis));
            provinces.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(provincesList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + provincesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Provinces.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Provinces provinces) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (provinces == null ? "null" : provinces.getId())));
        boolean result = false;
        if (provinces == null) {
            return true;
        }
        provinces.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)provinces);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + provinces));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + provinces));
        }
        return result;
    }

    public boolean updateList(List<Provinces> provincesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (provincesList == null ? "null" : Integer.valueOf(provincesList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(provincesList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Provinces provinces : provincesList) {
            provinces.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(provincesList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + provincesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + provincesList.size()));
        return result;
    }

    public Provinces getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Provinces provinces = null;
        if (id == null) {
            return provinces;
        }
        try {
            provinces = (Provinces)this.dao.get(Provinces.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return provinces;
    }

    public List<Provinces> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List provinces = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Provinces>();
        }
        try {
            provinces = this.dao.getList(Provinces.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (provinces == null ? "null" : Integer.valueOf(provinces.size()))));
        return provinces;
    }

    public Long getProvincesIdByProvince(String province) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by province  : " + province));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getProvincesIdByProvince", new Object[]{province});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by province  : " + province));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getProvincesIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProvincesIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProvincesIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getProvincesIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getProvincesIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

