/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Project;
import com.ptteng.common.skill.service.ProjectService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProjectServiceImpl
extends BaseDaoServiceImpl
implements ProjectService {
    private static final Log log = LogFactory.getLog(ProjectServiceImpl.class);

    public Long insert(Project project) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + project));
        if (project == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        project.setCreateAt(Long.valueOf(currentTimeMillis));
        project.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)project);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + project));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Project> insertList(List<Project> projectList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (projectList == null ? "null" : Integer.valueOf(projectList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(projectList)) {
            return new ArrayList<Project>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Project project : projectList) {
            project.setCreateAt(Long.valueOf(currentTimeMillis));
            project.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(projectList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + projectList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Project.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Project project) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (project == null ? "null" : project.getId())));
        boolean result = false;
        if (project == null) {
            return true;
        }
        project.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)project);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + project));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + project));
        }
        return result;
    }

    public boolean updateList(List<Project> projectList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (projectList == null ? "null" : Integer.valueOf(projectList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(projectList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Project project : projectList) {
            project.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(projectList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + projectList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + projectList.size()));
        return result;
    }

    public Project getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Project project = null;
        if (id == null) {
            return project;
        }
        try {
            project = (Project)this.dao.get(Project.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return project;
    }

    public List<Project> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List project = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Project>();
        }
        try {
            project = this.dao.getList(Project.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (project == null ? "null" : Integer.valueOf(project.size()))));
        return project;
    }

    public List<Long> getProjectIdsByIterationIdOrderByCreateAt(Long iterationId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by iterationId,start,limit  : " + iterationId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProjectIdsByIterationIdOrderByCreateAt", new Object[]{iterationId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by iterationId,start,limit)  : " + iterationId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getProjectIdsByTidAndStatusOrderByCreateAt(Long tid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by tid,status,start,limit  : " + tid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProjectIdsByTidAndStatusOrderByCreateAt", new Object[]{tid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by tid,status,start,limit)  : " + tid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getProjectIdsByTidOrderByCreateAt(Long tid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by tid,start,limit  : " + tid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProjectIdsByTidOrderByCreateAt", new Object[]{tid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by tid,start,limit)  : " + tid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getProjectIdsByNameOrderByCreateAt(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by name,start,limit  : " + name + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProjectIdsByNameOrderByCreateAt", new Object[]{name}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by name,start,limit)  : " + name + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProjectIdsByIterationIdOrderByCreateAt(Long iterationId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by iterationId  : " + iterationId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProjectIdsByIterationIdOrderByCreateAt", new Object[]{iterationId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by iterationId)  : " + iterationId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countProjectIdsByTidAndStatusOrderByCreateAt(Long tid, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by tid,status  : " + tid + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProjectIdsByTidAndStatusOrderByCreateAt", new Object[]{tid, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by tid,status)  : " + tid + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countProjectIdsByTidOrderByCreateAt(Long tid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by tid  : " + tid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProjectIdsByTidOrderByCreateAt", new Object[]{tid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by tid)  : " + tid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countProjectIdsByNameOrderByCreateAt(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by name  : " + name));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProjectIdsByNameOrderByCreateAt", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by name)  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getProjectIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProjectIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProjectIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getProjectIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getProjectIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

