package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Uevent;
import com.ptteng.common.skill.service.UeventService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UeventServiceImpl extends BaseDaoServiceImpl implements UeventService {

 

	private static final Log log = LogFactory.getLog(UeventServiceImpl.class);



		   
		@Override
		public Long insert(Uevent uevent)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + uevent);

		if (uevent == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		uevent.setCreateAt(currentTimeMillis);
		uevent.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(uevent);
		} catch (DaoException e) {
			log.error(" insert wrong : " + uevent);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Uevent> insertList(List<Uevent> ueventList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (ueventList == null ? "null" : ueventList.size()));
      
		List<Uevent> resultList = null;

		if (CollectionUtils.isEmpty(ueventList)) {
			return new ArrayList<Uevent>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Uevent uevent : ueventList) {
			uevent.setCreateAt(currentTimeMillis);
			uevent.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Uevent>) dao.batchSave(ueventList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + ueventList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Uevent.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Uevent uevent)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (uevent == null ? "null" : uevent.getId()));

		boolean result = false;

		if (uevent == null) {
			return true;
		}

		uevent.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(uevent);
		} catch (DaoException e) {
			log.error(" update wrong : " + uevent);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + uevent);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Uevent> ueventList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (ueventList == null ? "null" : ueventList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(ueventList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Uevent uevent : ueventList) {
			uevent.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(ueventList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + ueventList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + ueventList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Uevent getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Uevent uevent = null;

		if (id == null) {
			return uevent;
		}

		try {
			uevent = (Uevent) dao.get(Uevent.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return uevent;		
		}	
		  
    	   
		@Override
		public List<Uevent> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Uevent> uevent = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Uevent>();
		}

		try {
			uevent = (List<Uevent>) dao.getList(Uevent.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (uevent == null ? "null" : uevent.size()));
    
		return uevent;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUeventIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUeventIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUeventIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUeventIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUeventIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUeventIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUeventIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUeventIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUeventIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

