package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Question;
import com.ptteng.common.skill.service.QuestionService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class QuestionServiceImpl extends BaseDaoServiceImpl implements QuestionService {

 

	private static final Log log = LogFactory.getLog(QuestionServiceImpl.class);



		   
		@Override
		public Long insert(Question question)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + question);

		if (question == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		question.setCreateAt(currentTimeMillis);
		question.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(question);
		} catch (DaoException e) {
			log.error(" insert wrong : " + question);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Question> insertList(List<Question> questionList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (questionList == null ? "null" : questionList.size()));
      
		List<Question> resultList = null;

		if (CollectionUtils.isEmpty(questionList)) {
			return new ArrayList<Question>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Question question : questionList) {
			question.setCreateAt(currentTimeMillis);
			question.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Question>) dao.batchSave(questionList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + questionList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Question.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Question question)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (question == null ? "null" : question.getId()));

		boolean result = false;

		if (question == null) {
			return true;
		}

		question.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(question);
		} catch (DaoException e) {
			log.error(" update wrong : " + question);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + question);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Question> questionList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (questionList == null ? "null" : questionList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(questionList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Question question : questionList) {
			question.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(questionList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + questionList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + questionList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Question getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Question question = null;

		if (id == null) {
			return question;
		}

		try {
			question = (Question) dao.get(Question.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return question;		
		}	
		  
    	   
		@Override
		public List<Question> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Question> question = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Question>();
		}

		try {
			question = (List<Question>) dao.getList(Question.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (question == null ? "null" : question.size()));
    
		return question;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getQuestionIdsByOidAndStatusAndAdoptOrderByAgreeNum(Long oid,Integer status,Integer adopt,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by oid,status,adopt,start,limit  : " + oid+" , "+status+" , "+adopt+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getQuestionIdsByOidAndStatusAndAdoptOrderByAgreeNum", new Object[] { oid,status,adopt},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by oid,status,adopt,start,limit)  : " + oid+" , "+status+" , "+adopt+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countQuestionIdsByOidAndStatusAndAdoptOrderByAgreeNum(Long oid,Integer status,Integer adopt)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by oid,status,adopt  : " + oid+" , "+status+" , "+adopt );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getQuestionIdsByOidAndStatusAndAdoptOrderByAgreeNum", new Object[] { oid,status,adopt});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by oid,status,adopt)  : " + oid+" , "+status+" , "+adopt );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getQuestionIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getQuestionIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countQuestionIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getQuestionIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getQuestionIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

