/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Stype;
import com.ptteng.common.skill.service.StypeService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StypeServiceImpl
extends BaseDaoServiceImpl
implements StypeService {
    private static final Log log = LogFactory.getLog(StypeServiceImpl.class);

    public Long insert(Stype stype) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + stype));
        if (stype == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        stype.setCreateAt(Long.valueOf(currentTimeMillis));
        stype.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)stype);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + stype));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Stype> insertList(List<Stype> stypeList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (stypeList == null ? "null" : Integer.valueOf(stypeList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(stypeList)) {
            return new ArrayList<Stype>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Stype stype : stypeList) {
            stype.setCreateAt(Long.valueOf(currentTimeMillis));
            stype.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(stypeList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + stypeList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Stype.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Stype stype) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (stype == null ? "null" : stype.getId())));
        boolean result = false;
        if (stype == null) {
            return true;
        }
        stype.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)stype);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + stype));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + stype));
        }
        return result;
    }

    public boolean updateList(List<Stype> stypeList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (stypeList == null ? "null" : Integer.valueOf(stypeList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(stypeList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Stype stype : stypeList) {
            stype.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(stypeList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + stypeList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + stypeList.size()));
        return result;
    }

    public Stype getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Stype stype = null;
        if (id == null) {
            return stype;
        }
        try {
            stype = (Stype)this.dao.get(Stype.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return stype;
    }

    public List<Stype> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List stype = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Stype>();
        }
        try {
            stype = this.dao.getList(Stype.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (stype == null ? "null" : Integer.valueOf(stype.size()))));
        return stype;
    }

    public List<Long> getStypeIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStypeIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStypeIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStypeIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStypeIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

