package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Label;
import com.ptteng.common.skill.service.LabelService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class LabelServiceImpl extends BaseDaoServiceImpl implements LabelService {

 

	private static final Log log = LogFactory.getLog(LabelServiceImpl.class);



		   
		@Override
		public Long insert(Label label)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + label);

		if (label == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		label.setCreateAt(currentTimeMillis);
		label.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(label);
		} catch (DaoException e) {
			log.error(" insert wrong : " + label);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Label> insertList(List<Label> labelList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (labelList == null ? "null" : labelList.size()));
      
		List<Label> resultList = null;

		if (CollectionUtils.isEmpty(labelList)) {
			return new ArrayList<Label>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Label label : labelList) {
			label.setCreateAt(currentTimeMillis);
			label.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Label>) dao.batchSave(labelList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + labelList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Label.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Label label)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (label == null ? "null" : label.getId()));

		boolean result = false;

		if (label == null) {
			return true;
		}

		label.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(label);
		} catch (DaoException e) {
			log.error(" update wrong : " + label);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + label);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Label> labelList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (labelList == null ? "null" : labelList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(labelList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Label label : labelList) {
			label.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(labelList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + labelList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + labelList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Label getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Label label = null;

		if (id == null) {
			return label;
		}

		try {
			label = (Label) dao.get(Label.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return label;		
		}	
		  
    	   
		@Override
		public List<Label> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Label> label = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Label>();
		}

		try {
			label = (List<Label>) dao.getList(Label.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (label == null ? "null" : label.size()));
    
		return label;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getLabelIdsByTidOrderByUpdateAt(Long tid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by tid,start,limit  : " + tid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getLabelIdsByTidOrderByUpdateAt", new Object[] { tid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by tid,start,limit)  : " + tid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getLabelIdsByTidAndStatusOrderByUpdateAt(Long tid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by tid,status,start,limit  : " + tid+" , "+status+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getLabelIdsByTidAndStatusOrderByUpdateAt", new Object[] { tid,status},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by tid,status,start,limit)  : " + tid+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countLabelIdsByTidOrderByUpdateAt(Long tid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by tid  : " + tid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getLabelIdsByTidOrderByUpdateAt", new Object[] { tid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by tid)  : " + tid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countLabelIdsByTidAndStatusOrderByUpdateAt(Long tid,Integer status)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by tid,status  : " + tid+" , "+status );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getLabelIdsByTidAndStatusOrderByUpdateAt", new Object[] { tid,status});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by tid,status)  : " + tid+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getLabelIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getLabelIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countLabelIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getLabelIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getLabelIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

