package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.DeepThink;
import com.ptteng.common.skill.service.DeepThinkService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class DeepThinkServiceImpl extends BaseDaoServiceImpl implements DeepThinkService {


    private static final Log log = LogFactory.getLog(DeepThinkServiceImpl.class);


    @Override
    public Long insert(DeepThink deepThink) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + deepThink);

        if (deepThink == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        deepThink.setCreateAt(currentTimeMillis);
        deepThink.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(deepThink);
        } catch (DaoException e) {
            log.error(" insert wrong : " + deepThink);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<DeepThink> insertList(List<DeepThink> deepThinkList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (deepThinkList == null ? "null" : deepThinkList.size()));

        List<DeepThink> resultList = null;

        if (CollectionUtils.isEmpty(deepThinkList)) {
            return new ArrayList<DeepThink>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DeepThink deepThink : deepThinkList) {
            deepThink.setCreateAt(currentTimeMillis);
            deepThink.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<DeepThink>) dao.batchSave(deepThinkList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + deepThinkList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(DeepThink.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(DeepThink deepThink) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (deepThink == null ? "null" : deepThink.getId()));

        boolean result = false;

        if (deepThink == null) {
            return true;
        }

        deepThink.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(deepThink);
        } catch (DaoException e) {
            log.error(" update wrong : " + deepThink);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + deepThink);
        }
        return result;
    }


    @Override
    public boolean updateList(List<DeepThink> deepThinkList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (deepThinkList == null ? "null" : deepThinkList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(deepThinkList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (DeepThink deepThink : deepThinkList) {
            deepThink.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(deepThinkList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + deepThinkList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + deepThinkList.size());

        return result;
    }


    @Override
    public DeepThink getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        DeepThink deepThink = null;

        if (id == null) {
            return deepThink;
        }

        try {
            deepThink = (DeepThink) dao.get(DeepThink.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return deepThink;
    }


    @Override
    public List<DeepThink> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<DeepThink> deepThink = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<DeepThink>();
        }

        try {
            deepThink = (List<DeepThink>) dao.getList(DeepThink.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (deepThink == null ? "null" : deepThink.size()));

        return deepThink;
    }


    @Override
    public List<Long> getDeepThinkIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getDeepThinkIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countDeepThinkIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getDeepThinkIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getDeepThinkIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

