/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.ClassSubject;
import com.ptteng.common.skill.service.ClassSubjectService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassSubjectServiceImpl
extends BaseDaoServiceImpl
implements ClassSubjectService {
    private static final Log log = LogFactory.getLog(ClassSubjectServiceImpl.class);

    public Long insert(ClassSubject classSubject) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + classSubject));
        if (classSubject == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        classSubject.setCreateAt(Long.valueOf(currentTimeMillis));
        classSubject.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)classSubject);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + classSubject));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<ClassSubject> insertList(List<ClassSubject> classSubjectList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (classSubjectList == null ? "null" : Integer.valueOf(classSubjectList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(classSubjectList)) {
            return new ArrayList<ClassSubject>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ClassSubject classSubject : classSubjectList) {
            classSubject.setCreateAt(Long.valueOf(currentTimeMillis));
            classSubject.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(classSubjectList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + classSubjectList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(ClassSubject.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(ClassSubject classSubject) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (classSubject == null ? "null" : classSubject.getId())));
        boolean result = false;
        if (classSubject == null) {
            return true;
        }
        classSubject.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)classSubject);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + classSubject));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + classSubject));
        }
        return result;
    }

    public boolean updateList(List<ClassSubject> classSubjectList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (classSubjectList == null ? "null" : Integer.valueOf(classSubjectList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(classSubjectList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (ClassSubject classSubject : classSubjectList) {
            classSubject.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(classSubjectList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + classSubjectList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + classSubjectList.size()));
        return result;
    }

    public ClassSubject getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        ClassSubject classSubject = null;
        if (id == null) {
            return classSubject;
        }
        try {
            classSubject = (ClassSubject)this.dao.get(ClassSubject.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return classSubject;
    }

    public List<ClassSubject> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List classSubject = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ClassSubject>();
        }
        try {
            classSubject = this.dao.getList(ClassSubject.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (classSubject == null ? "null" : Integer.valueOf(classSubject.size()))));
        return classSubject;
    }

    public List<Long> getClassSubjectIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassSubjectIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countClassSubjectIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getClassSubjectIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getClassSubjectIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

