package com.ptteng.common.skill.uitl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.common.util.StringUtil;
import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.common.skill.model.Order;
//import com.ptteng.skill.order.model.OrderSku;
//import com.qding.common.pay.service.IndentInfoService;
import com.ptteng.common.skill.service.OrderService;
import com.ptteng.common.skill.util.OrderStatus;
import com.qding.common.pay.service.IndentInfoService;
import com.qding.common.pay.service.PayOrderService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by lhwarthas on 16/4/13.
 */

public class scheduleTask {

    public static final String PAY_CAIFUTONG = "cftPay";//兴业财付通
    public static final String PAY_XINGYE = "xyPay";//兴业微信
    public static final Integer SUCCESS = 1;//成功
    public static final Integer FAILURE = 2;//失败

    public static final Integer PAY_MANNER_UNIONPAY = 2;

    public static final Integer PAY_MANNER_ALIPAY = 3;

    public static final Integer PAY_MANNER_WEIXIN = 4;
    public static final Integer PAY_MANNER_TONGLIIAN = 5;


    @Autowired
    private IndentInfoService indentInfoService;

    @Autowired
    private OrderService orderService;

//    @Resource(name = "fundService")
//    private FundService fundService;

    @Resource(name = "payOrderService")
    private PayOrderService payOrderService;

//    @Autowired
//    private OrderSkuService orderSkuService;
//
//    @Resource(name = "skuService")
//    private SkuService skuService;

    private Log log = LogFactory.getLog(scheduleTask.class);

//    public void aliPayQueue() {
//
//        Integer count = orderService.countStatusList(new Object[]{OrderStatus.WAITFORPAY});
//
//        Integer page = count / 10;
//
//        for (int i = 1; i <= page + 1; ++i) {
//            List<Long> orderIdList = orderService.getStatusList(new Object[]{OrderStatus.WAITFORPAY}, (i - 1) * 10, 10, true);
//            List<Order> orders = orderService.getObjectList(orderIdList);
//            List<String> orderIds = new ArrayList<>();
//            for(Order order : orders)
//            {
//                orderIds.add(order.getOrderId());
//            }
//            log.info("get orderIdList : " + orderIdList);
//            orderIds.stream().forEach(n -> {
//                log.info("query order id : " + n);
//                indentInfoService.AliPayStatusQuery(n);
//            });
//        }
//    }

    public void payQueue() throws ServiceException, ServiceDaoException {
        log.info(" payQueue  start ...  ");

        // 查询状态为未支付的订单
//        Integer count = orderService.countStatusList(new Object[]{OrderStatus.WAITFORPAY});

        Integer count = orderService.countOrderIdsByStatus(OrderStatus.WAITFORPAY);
        log.info("  count = "+count);
        Integer page = count / 10;
        for (int i = 1; i <= page + 1; ++i) {

            // 获取订单id
//            List<Long> orderIdList = orderService.getStatusList(new Object[]{OrderStatus.WAITFORPAY}, (i - 1) * 10, 10, true);
              List<Long> orderIdList = orderService.getOrderIdsByStatus(OrderStatus.WAITFORPAY,(i - 1) * 10, 10);
//            List<Order> orders = orderService.getObjectList(orderIdList);
            List<Order> orders = orderService.getObjectsByIds(orderIdList);
            for(Order order : orders)
            {
                if (!Integer.valueOf(OrderStatus.WAITFORPAY).equals(order.getStatus())) {
                    log.info(" finish ");
                } else {
                    // 如果是待支付，查银行
                    Integer payManner = order.getPayManner();//支付方式
                    log.info("  payManner = " + payManner);
                    if(null == payManner){
                        log.info("  payManner is null  " );
                    }else{
                        switch (payManner) {
                            case Order.PAYMANNER_1: {

                                break;
                            }
                            case Order.PAYMANNER_2: {
                                log.info(" order.getPayAt()  = "+order.getPayAt());
                                if(null == order.getPayAt() ){
                                    log.info(" waiting  pay ");
                                }else {
                                    //银行卡
                                    String result = payOrderService.check(order.getOrderId(),

                                            MyTimeUtil.convertLong2String(order.getPayAt(),
                                                    "yyyyMMdd"), PAY_CAIFUTONG);

                                    log.info("  result json = " + result);
                                    XingyeResult xingyeResult = GsonUtil.fromJson(result, XingyeResult.class);

                                    if ("-1".equals(result)) {
                                        //查询失败
                                        log.info("  code = -1");
                                    } else {
                                        //查询成功
                                        log.info("  code = 0");
                                        String trans_status = xingyeResult.getTrans_status();
                                        log.info("  trans_status = " + trans_status);
                                        if (StringUtil.isEmpty(trans_status)) {
                                            log.info(" error ");
                                        } else {
                                            if ("1".equals(trans_status)) {
                                                log.info("  SUCCESS ");
                                                //支付成功
                                                indentInfoService.noticeBack(order.getOrderId(), SUCCESS, PAY_MANNER_UNIONPAY);

                                            } else if ("2".equals(trans_status)) {
                                                //支付失败
                                                //indentInfoService.noticeBack(order.getOrderId(), FAILURE, PayBackController.PAY_MANNER_UNIONPAY);
                                            } else {
                                                //支付待支付
                                                //  model.addAttribute("tradeState", 2);
                                            }
                                        }
                                    }
                                }
                                break;
                            }

                            case Order.PAYMANNER_3: {
                                //支付宝
                                boolean res = indentInfoService.AliPayStatusQuery(order.getOrderId());


                                if (res) {
                                    log.info(" SUCCESS  ");
                                    indentInfoService.noticeBack(order.getOrderId(), SUCCESS, PAY_MANNER_ALIPAY);
                                } else {
                                    log.info(" failure  ");
                                }
                                break;
                            }
                            case Order.PAYMANNER_4: {
                                //微信

                                String result = payOrderService.check(order.getOrderId(), "", PAY_XINGYE);
                                log.info("  result = " + result);
                                XingyeResult xingyeResult = GsonUtil.fromJson(result, XingyeResult.class);
                                if ("0".equals(xingyeResult.getCode())) {
                                    log.info("  success ");
                                    if ("SUCCESS".equals(xingyeResult.getTradeState())) {
                                        //支付成功
                                        indentInfoService.noticeBack(order.getOrderId(), SUCCESS, PAY_MANNER_WEIXIN);
                                    } else if("PAYERROR".equals(xingyeResult.getTradeState())) {
                                        //支付失败
                                        //indentInfoService.noticeBack(order.getOrderId(), FAILURE, PAY_MANNER_WEIXIN);
                                    }else{
                                        //待支付
                                    }
                                } else {

                                }

                                break;

                            }
                            default:break;
                        }

                    }

                }
            }

        }


    }



    /**
     * 超过24小时订单失效
     */

//    public void orderEffectTimeQuery() {
//        Integer count = orderService.countStatusList(new Object[]{OrderStatus.WAITFORPAY});
//        Integer page = count / 10;
//        for (int i = 0; i < page + 1; ++i) {
//            List<Long> orderIdList = orderService.getStatusList(new Object[]{OrderStatus.WAITFORPAY}, (i - 1) * 10, 10, true);
//            List<Order> orders = orderService.getObjectList(orderIdList);
//            orders.stream().filter(order -> 86400000 < System.currentTimeMillis() - order.getCreateAt()).forEach(order -> {
//                log.info("get order : " + order);
//                order.setStatus(OrderStatus.CLOSED);
//                List<Long> orderSkuIdList = orderSkuService.getOrderSkuList(new Object[]{order.getId()}, 0, Integer.MAX_VALUE, true);
//                log.info("get orderSkuIdList : " + orderSkuIdList + "by orderPrimary key : " + order.getId());
//                List<OrderSku> orderSkus = orderSkuService.getObjectList(orderSkuIdList);
//                orderSkus.stream().forEach(orderSku -> skuService.changeStock(orderSku.getskuId(), Long.valueOf(orderSku.getcnt()), DalConstants.SKU_ACTION_STOCK_UP));
//                orderService.update(order);
//            });
//        }
//    }

    /**
     * 待收货,超过14天,状态改为完成收货
     */

//    public void autoConfirmRecived() {
//        Integer count = orderService.countStatusList(new Object[]{OrderStatus.WAITFORRECEIVE});
//        Integer page = count / 10;
//        for (int i = 0; i < page + 1; ++i) {
//            List<Long> orderIdList = orderService.getStatusList(new Object[]{OrderStatus.WAITFORRECEIVE}, (i - 1) * 10, 10, true);
//            log.info("get waitforreceive id list : " + orderIdList);
//            List<Order> orders = orderService.getObjectList(orderIdList);
//            orders.stream().filter(order -> 1209600000 < System.currentTimeMillis() - order.getStartTransport()).forEach(order -> {
//                log.info("get order : " + order);
//                order.setStatus(OrderStatus.COMPLETED);//订单状态设为完成;
//                orderService.addScore(order);
//                orderService.changeFund(order, order.getUserId());
//                orderService.addComment(order);
//                orderService.addDealRecord(order);
//                order.setConfirmRecieved(System.currentTimeMillis());
//                orderService.update(order);
//            });
//        }
//    }

    /**
     * 提现
     */
//    public void paymentEffectTimeQuery() {
//        log.info("  quartz  paymentEffectTimeQuery start ... ");
//        Map<String, Object> allListParam = FundUtil.getFundParamter( Fund.DEALTYPE_3, Fund.STATUS_2, false);
//        List<Long> fundIdList= fundService.getIdsByDynamicCondition(Fund.class,allListParam,0,Integer.MAX_VALUE);
//
//        log.info(" fundIdList size =  "+fundIdList.size());
//        if(fundIdList.size()>0){
//            log.info("  start ..  ");
//            List<Fund> fundList = fundService.getObjectList(fundIdList);
//            for(Fund fund : fundList){
//                log.info(" fund id = "+fund.getId());
//                String result =  payOrderService.checkPayment(fund.getdealNo(),"",PAY_CAIFUTONG);
//                log.info("  result = "+result);
//                if("-1".equals(result)){
//                    //调用失败
//                    log.info(" result =  -1  " + result);
//                }else{
//                    XingyeResult xingyeResult = GsonUtil.fromJson(result, XingyeResult.class);
//                    String transStatus = xingyeResult.getTransStatus();
//                    try {
//                    if ("1".equals(transStatus)) {
//                        log.info(" success ");
//                        //提现成功
//                        //1：改状态：改为提现成功
//                        indentInfoService.paymentStatus(fund.getId(), fund.getuserId(), fund.getincome(), SUCCESS);
//
//                    } else if("2".equals(transStatus)) {
//                        log.info(" failure ");
//                        //提现失败
//                        //回调函数里：1：改状态，改为提现失败 2：回滚余额
//                        indentInfoService.paymentStatus(fund.getId(), fund.getuserId(),fund.getincome(),FAILURE );
//
//                    }else{
//                        log.info(" waiting ");
//                        //支付待支付:未决
//                        //不修改订单状态
//                    }
//                    } catch (ServiceException e) {
//                        e.printStackTrace();
//                    } catch (ServiceDaoException e) {
//                        e.printStackTrace();
//                    }
//                }
//            }
//        }
//    }

}
