package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.UserArticleRelation;
import com.ptteng.common.skill.service.UserArticleRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserArticleRelationServiceImpl extends BaseDaoServiceImpl implements UserArticleRelationService {

 

	private static final Log log = LogFactory.getLog(UserArticleRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserArticleRelation userArticleRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userArticleRelation);

		if (userArticleRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userArticleRelation.setCreateAt(currentTimeMillis);
		userArticleRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userArticleRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userArticleRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserArticleRelation> insertList(List<UserArticleRelation> userArticleRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userArticleRelationList == null ? "null" : userArticleRelationList.size()));
      
		List<UserArticleRelation> resultList = null;

		if (CollectionUtils.isEmpty(userArticleRelationList)) {
			return new ArrayList<UserArticleRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserArticleRelation userArticleRelation : userArticleRelationList) {
			userArticleRelation.setCreateAt(currentTimeMillis);
			userArticleRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserArticleRelation>) dao.batchSave(userArticleRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userArticleRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserArticleRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserArticleRelation userArticleRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userArticleRelation == null ? "null" : userArticleRelation.getId()));

		boolean result = false;

		if (userArticleRelation == null) {
			return true;
		}

		userArticleRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userArticleRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userArticleRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userArticleRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserArticleRelation> userArticleRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userArticleRelationList == null ? "null" : userArticleRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userArticleRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserArticleRelation userArticleRelation : userArticleRelationList) {
			userArticleRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userArticleRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userArticleRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userArticleRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserArticleRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserArticleRelation userArticleRelation = null;

		if (id == null) {
			return userArticleRelation;
		}

		try {
			userArticleRelation = (UserArticleRelation) dao.get(UserArticleRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userArticleRelation;		
		}	
		  
    	   
		@Override
		public List<UserArticleRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserArticleRelation> userArticleRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserArticleRelation>();
		}

		try {
			userArticleRelation = (List<UserArticleRelation>) dao.getList(UserArticleRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userArticleRelation == null ? "null" : userArticleRelation.size()));
    
		return userArticleRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getUserArticleRelationIdByUidAndAidAndTypeAndTargetType(Long uid,Long aid,Integer type,Integer targetType)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by uid,aid,type  : " + uid+" , "+aid+" , "+type+" , "+targetType);
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getUserArticleRelationIdByUidAndAidAndTypeAndTargetType", new Object[] {uid,aid,type,targetType});
   } catch (DaoException e) {
			log.error(" get id wrong by uid,aid,type  : " + uid+" , "+aid+" , "+type+" , "+targetType);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}

	@Override
	public Long getUserArticleRelationIdByUidAndAidAndTypeAndWeather(Long uid, Long aid, Integer type, Integer weather) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get id by uid,aid,type,weather  : " + uid+" , "+aid+" , "+type +" , "+weather);
		}
		Long id = null;
		try {



			id = (Long) dao.getMapping("getUserArticleRelationIdByUidAndAidAndTypeAndWeather", new Object[] {uid,aid,type,weather });
		} catch (DaoException e) {
			log.error(" get id wrong by uid,aid,type,weather  : " + uid+" , "+aid+" , "+type+" , "+weather );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;

	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserArticleRelationIdsByUidAndTypeAndWhether(Long uid,Integer type,Integer whether,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,type,whether,start,limit  : " + uid+" , "+type+" , "+whether+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserArticleRelationIdsByUidAndTypeAndWhether", new Object[] { uid,type,whether},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,type,whether,start,limit)  : " + uid+" , "+type+" , "+whether+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserArticleRelationIdsByAidAndTypeAndWhether(Long aid,Integer type,Integer whether,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by aid,type,whether,start,limit  : " + aid+" , "+type+" , "+whether+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserArticleRelationIdsByAidAndTypeAndWhether", new Object[] { aid,type,whether},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by aid,type,whether,start,limit)  : " + aid+" , "+type+" , "+whether+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserArticleRelationIdsByUidAndTypeAndWhether(Long uid,Integer type,Integer whether)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid,type,whether  : " + uid+" , "+type+" , "+whether );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserArticleRelationIdsByUidAndTypeAndWhether", new Object[] { uid,type,whether});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid,type,whether)  : " + uid+" , "+type+" , "+whether );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserArticleRelationIdsByAidAndTypeAndWhether(Long aid,Integer type,Integer whether)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by aid,type,whether  : " + aid+" , "+type+" , "+whether );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserArticleRelationIdsByAidAndTypeAndWhether", new Object[] { aid,type,whether});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by aid,type,whether)  : " + aid+" , "+type+" , "+whether );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserArticleRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserArticleRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserArticleRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserArticleRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserArticleRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

