package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.ClassTimetable;
import com.ptteng.common.skill.service.ClassTimetableService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ClassTimetableServiceImpl extends BaseDaoServiceImpl implements ClassTimetableService {


    private static final Log log = LogFactory.getLog(ClassTimetableServiceImpl.class);


    @Override
    public Long insert(ClassTimetable classTimetable) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + classTimetable);

        if (classTimetable == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        classTimetable.setCreateAt(currentTimeMillis);
        classTimetable.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(classTimetable);
        } catch (DaoException e) {
            log.error(" insert wrong : " + classTimetable);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<ClassTimetable> insertList(List<ClassTimetable> classTimetableList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (classTimetableList == null ? "null" : classTimetableList.size()));

        List<ClassTimetable> resultList = null;

        if (CollectionUtils.isEmpty(classTimetableList)) {
            return new ArrayList<ClassTimetable>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (ClassTimetable classTimetable : classTimetableList) {
            classTimetable.setCreateAt(currentTimeMillis);
            classTimetable.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<ClassTimetable>) dao.batchSave(classTimetableList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + classTimetableList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(ClassTimetable.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(ClassTimetable classTimetable) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (classTimetable == null ? "null" : classTimetable.getId()));

        boolean result = false;

        if (classTimetable == null) {
            return true;
        }

        classTimetable.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(classTimetable);
        } catch (DaoException e) {
            log.error(" update wrong : " + classTimetable);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + classTimetable);
        }
        return result;
    }


    @Override
    public boolean updateList(List<ClassTimetable> classTimetableList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (classTimetableList == null ? "null" : classTimetableList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(classTimetableList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (ClassTimetable classTimetable : classTimetableList) {
            classTimetable.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(classTimetableList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + classTimetableList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + classTimetableList.size());

        return result;
    }


    @Override
    public ClassTimetable getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        ClassTimetable classTimetable = null;

        if (id == null) {
            return classTimetable;
        }

        try {
            classTimetable = (ClassTimetable) dao.get(ClassTimetable.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return classTimetable;
    }


    @Override
    public List<ClassTimetable> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<ClassTimetable> classTimetable = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ClassTimetable>();
        }

        try {
            classTimetable = (List<ClassTimetable>) dao.getList(ClassTimetable.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (classTimetable == null ? "null" : classTimetable.size()));

        return classTimetable;
    }


    @Override
    public List<Long> getClassTimetableIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getClassTimetableIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countClassTimetableIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getClassTimetableIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getClassTimetableIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

