package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.ClassSubject;
import com.ptteng.common.skill.service.ClassSubjectService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ClassSubjectServiceImpl extends BaseDaoServiceImpl implements ClassSubjectService {


    private static final Log log = LogFactory.getLog(ClassSubjectServiceImpl.class);


    @Override
    public Long insert(ClassSubject classSubject) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + classSubject);

        if (classSubject == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        classSubject.setCreateAt(currentTimeMillis);
        classSubject.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(classSubject);
        } catch (DaoException e) {
            log.error(" insert wrong : " + classSubject);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<ClassSubject> insertList(List<ClassSubject> classSubjectList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (classSubjectList == null ? "null" : classSubjectList.size()));

        List<ClassSubject> resultList = null;

        if (CollectionUtils.isEmpty(classSubjectList)) {
            return new ArrayList<ClassSubject>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (ClassSubject classSubject : classSubjectList) {
            classSubject.setCreateAt(currentTimeMillis);
            classSubject.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<ClassSubject>) dao.batchSave(classSubjectList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + classSubjectList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(ClassSubject.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(ClassSubject classSubject) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (classSubject == null ? "null" : classSubject.getId()));

        boolean result = false;

        if (classSubject == null) {
            return true;
        }

        classSubject.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(classSubject);
        } catch (DaoException e) {
            log.error(" update wrong : " + classSubject);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + classSubject);
        }
        return result;
    }


    @Override
    public boolean updateList(List<ClassSubject> classSubjectList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (classSubjectList == null ? "null" : classSubjectList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(classSubjectList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (ClassSubject classSubject : classSubjectList) {
            classSubject.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(classSubjectList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + classSubjectList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + classSubjectList.size());

        return result;
    }


    @Override
    public ClassSubject getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        ClassSubject classSubject = null;

        if (id == null) {
            return classSubject;
        }

        try {
            classSubject = (ClassSubject) dao.get(ClassSubject.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return classSubject;
    }


    @Override
    public List<ClassSubject> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<ClassSubject> classSubject = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ClassSubject>();
        }

        try {
            classSubject = (List<ClassSubject>) dao.getList(ClassSubject.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (classSubject == null ? "null" : classSubject.size()));

        return classSubject;
    }


    @Override
    public List<Long> getClassSubjectIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getClassSubjectIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countClassSubjectIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getClassSubjectIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getClassSubjectIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

