package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Answer;
import com.ptteng.common.skill.service.AnswerService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class AnswerServiceImpl extends BaseDaoServiceImpl implements AnswerService {

 

	private static final Log log = LogFactory.getLog(AnswerServiceImpl.class);



		   
		@Override
		public Long insert(Answer answer)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + answer);

		if (answer == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		answer.setCreateAt(currentTimeMillis);
		answer.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(answer);
		} catch (DaoException e) {
			log.error(" insert wrong : " + answer);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Answer> insertList(List<Answer> answerList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (answerList == null ? "null" : answerList.size()));
      
		List<Answer> resultList = null;

		if (CollectionUtils.isEmpty(answerList)) {
			return new ArrayList<Answer>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Answer answer : answerList) {
			answer.setCreateAt(currentTimeMillis);
			answer.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Answer>) dao.batchSave(answerList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + answerList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Answer.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Answer answer)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (answer == null ? "null" : answer.getId()));

		boolean result = false;

		if (answer == null) {
			return true;
		}

		answer.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(answer);
		} catch (DaoException e) {
			log.error(" update wrong : " + answer);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + answer);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Answer> answerList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (answerList == null ? "null" : answerList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(answerList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Answer answer : answerList) {
			answer.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(answerList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + answerList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + answerList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Answer getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Answer answer = null;

		if (id == null) {
			return answer;
		}

		try {
			answer = (Answer) dao.get(Answer.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return answer;		
		}	
		  
    	   
		@Override
		public List<Answer> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Answer> answer = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Answer>();
		}

		try {
			answer = (List<Answer>) dao.getList(Answer.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (answer == null ? "null" : answer.size()));
    
		return answer;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getAnswerIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getAnswerIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countAnswerIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getAnswerIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getAnswerIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

