/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Skill;
import com.ptteng.common.skill.service.SkillService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SkillServiceImpl
extends BaseDaoServiceImpl
implements SkillService {
    private static final Log log = LogFactory.getLog(SkillServiceImpl.class);

    public Long insert(Skill skill) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + skill));
        if (skill == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        skill.setCreateAt(Long.valueOf(currentTimeMillis));
        skill.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)skill);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + skill));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Skill> insertList(List<Skill> skillList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (skillList == null ? "null" : Integer.valueOf(skillList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(skillList)) {
            return new ArrayList<Skill>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Skill skill : skillList) {
            skill.setCreateAt(Long.valueOf(currentTimeMillis));
            skill.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(skillList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + skillList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Skill.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Skill skill) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (skill == null ? "null" : skill.getId())));
        boolean result = false;
        if (skill == null) {
            return true;
        }
        skill.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)skill);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + skill));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + skill));
        }
        return result;
    }

    public boolean updateList(List<Skill> skillList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (skillList == null ? "null" : Integer.valueOf(skillList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(skillList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Skill skill : skillList) {
            skill.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(skillList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + skillList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + skillList.size()));
        return result;
    }

    public Skill getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Skill skill = null;
        if (id == null) {
            return skill;
        }
        try {
            skill = (Skill)this.dao.get(Skill.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return skill;
    }

    public List<Skill> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List skill = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Skill>();
        }
        try {
            skill = this.dao.getList(Skill.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (skill == null ? "null" : Integer.valueOf(skill.size()))));
        return skill;
    }

    public List<Long> getSkillIdsByOid(Long oid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by oid,start,limit  : " + oid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSkillIdsByOid", new Object[]{oid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by oid,start,limit)  : " + oid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getIdsByParentId(Long parentId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by parentId,start,limit  : " + parentId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIdsByParentId", new Object[]{parentId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by parentId,start,limit)  : " + parentId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getIdsByOccupationId(Long occupationId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by occupationId,start,limit  : " + occupationId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getIdsByOccupationId", new Object[]{occupationId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by occupationId,start,limit)  : " + occupationId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countIdsByOccupationId(Long occupationId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by occupationId  : " + occupationId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getIdsByOccupationId", new Object[]{occupationId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by occupationId)  : " + occupationId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countSkillIdsByOid(Long oid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by oid  : " + oid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getSkillIdsByOid", new Object[]{oid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by oid)  : " + oid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getSkillIdsByTid(Long tid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by tid,start,limit  : " + tid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSkillIdsByTid", new Object[]{tid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by tid,start,limit)  : " + tid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getSkillIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSkillIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSkillIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSkillIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSkillIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

