package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.SchoolPersonRelation;
import com.ptteng.common.skill.service.SchoolPersonRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class SchoolPersonRelationServiceImpl extends BaseDaoServiceImpl implements SchoolPersonRelationService {

 

	private static final Log log = LogFactory.getLog(SchoolPersonRelationServiceImpl.class);



		   
		@Override
		public Long insert(SchoolPersonRelation schoolPersonRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + schoolPersonRelation);

		if (schoolPersonRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		schoolPersonRelation.setCreateAt(currentTimeMillis);
		schoolPersonRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(schoolPersonRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + schoolPersonRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<SchoolPersonRelation> insertList(List<SchoolPersonRelation> schoolPersonRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (schoolPersonRelationList == null ? "null" : schoolPersonRelationList.size()));
      
		List<SchoolPersonRelation> resultList = null;

		if (CollectionUtils.isEmpty(schoolPersonRelationList)) {
			return new ArrayList<SchoolPersonRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (SchoolPersonRelation schoolPersonRelation : schoolPersonRelationList) {
			schoolPersonRelation.setCreateAt(currentTimeMillis);
			schoolPersonRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<SchoolPersonRelation>) dao.batchSave(schoolPersonRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + schoolPersonRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(SchoolPersonRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(SchoolPersonRelation schoolPersonRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (schoolPersonRelation == null ? "null" : schoolPersonRelation.getId()));

		boolean result = false;

		if (schoolPersonRelation == null) {
			return true;
		}

		schoolPersonRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(schoolPersonRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + schoolPersonRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + schoolPersonRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<SchoolPersonRelation> schoolPersonRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (schoolPersonRelationList == null ? "null" : schoolPersonRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(schoolPersonRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (SchoolPersonRelation schoolPersonRelation : schoolPersonRelationList) {
			schoolPersonRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(schoolPersonRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + schoolPersonRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + schoolPersonRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public SchoolPersonRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		SchoolPersonRelation schoolPersonRelation = null;

		if (id == null) {
			return schoolPersonRelation;
		}

		try {
			schoolPersonRelation = (SchoolPersonRelation) dao.get(SchoolPersonRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return schoolPersonRelation;		
		}	
		  
    	   
		@Override
		public List<SchoolPersonRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<SchoolPersonRelation> schoolPersonRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<SchoolPersonRelation>();
		}

		try {
			schoolPersonRelation = (List<SchoolPersonRelation>) dao.getList(SchoolPersonRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (schoolPersonRelation == null ? "null" : schoolPersonRelation.size()));
    
		return schoolPersonRelation;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getSchoolPersonRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getSchoolPersonRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countSchoolPersonRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getSchoolPersonRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getSchoolPersonRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

