/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Question;
import com.ptteng.common.skill.service.QuestionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuestionServiceImpl
extends BaseDaoServiceImpl
implements QuestionService {
    private static final Log log = LogFactory.getLog(QuestionServiceImpl.class);

    public Long insert(Question question) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + question));
        if (question == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        question.setCreateAt(Long.valueOf(currentTimeMillis));
        question.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)question);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + question));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Question> insertList(List<Question> questionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (questionList == null ? "null" : Integer.valueOf(questionList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(questionList)) {
            return new ArrayList<Question>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Question question : questionList) {
            question.setCreateAt(Long.valueOf(currentTimeMillis));
            question.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(questionList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + questionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Question.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Question question) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (question == null ? "null" : question.getId())));
        boolean result = false;
        if (question == null) {
            return true;
        }
        question.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)question);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + question));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + question));
        }
        return result;
    }

    public boolean updateList(List<Question> questionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (questionList == null ? "null" : Integer.valueOf(questionList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(questionList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Question question : questionList) {
            question.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(questionList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + questionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + questionList.size()));
        return result;
    }

    public Question getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Question question = null;
        if (id == null) {
            return question;
        }
        try {
            question = (Question)this.dao.get(Question.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return question;
    }

    public List<Question> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List question = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Question>();
        }
        try {
            question = this.dao.getList(Question.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (question == null ? "null" : Integer.valueOf(question.size()))));
        return question;
    }

    public List<Long> getQuestionIdsByOidAndStatusAndAdoptOrderByAgreeNum(Long oid, Integer status, Integer adopt, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by oid,status,adopt,start,limit  : " + oid + " , " + status + " , " + adopt + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getQuestionIdsByOidAndStatusAndAdoptOrderByAgreeNum", new Object[]{oid, status, adopt}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by oid,status,adopt,start,limit)  : " + oid + " , " + status + " , " + adopt + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countQuestionIdsByOidAndStatusAndAdoptOrderByAgreeNum(Long oid, Integer status, Integer adopt) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by oid,status,adopt  : " + oid + " , " + status + " , " + adopt));
        }
        Integer count = null;
        try {
            count = this.dao.count("getQuestionIdsByOidAndStatusAndAdoptOrderByAgreeNum", new Object[]{oid, status, adopt});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by oid,status,adopt)  : " + oid + " , " + status + " , " + adopt));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getQuestionIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getQuestionIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countQuestionIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getQuestionIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getQuestionIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

