package com.ptteng.common.skill.service.impl;

import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.TemplateTestService;
import com.qding.common.util.DataUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by J.w on 2018/3/23.
 * 功能描述：
 */
public class TemplateTestServiceImpl implements TemplateTestService {

    private static final Log log = LogFactory.getLog(TemplateTestServiceImpl.class);

    private JdbcTemplate template;

    public JdbcTemplate getTemplate() {
        return template;
    }

    public void setTemplate(JdbcTemplate template) {
        this.template = template;
    }

    private static final Integer CONDITION_AGE = 1;  //饼图-按年龄筛选
    private static final Integer CONDITION_CITY = 2;  //饼图-按籍贯（城市）筛选
    private static final Integer CONDITION_GRADE = 3;  //饼图-按学历筛选
    private static final Integer CONDITION_MAJOR = 4;  //饼图-按专业筛选
    private static final Integer CONDITION_SCHOOL =5;  //饼图-按学校筛选

    //校正所有未读消息为负数的情况
    @Override
    public void updateIsLookNumber() {

        String sql = "update user a set a.is_look = (select count(id) from message b where b.receive_id = a.id and b.unread = 1 and b.type!=\"collection\" and b.type!=\"like\" and b.type!=\"private\") where a.is_look < 0;";

        log.info("update users isLook by execute sql: " + sql);

        template.update(sql);
    }

    //22期 - 档案管理 - 按条件展示折线图
    @Override
    public List<InDoorStudentStatistics> getLineChartByParams(String school, String place, String major, Integer grade, Integer occupationId, Integer age, Long minStartAt, Long maxStartAt) {

        StringBuffer sb = new StringBuffer();
        List<Object> objectList = new ArrayList<>();

//        String prefix = "select a.day, a.number, (@totalNumber := @totalNumber + a.number) totalNumber from (select UNIX_TIMESTAMP(DATE_FORMAT(FROM_UNIXTIME(u.start_at/1000), '%Y-%m-%d'))*1000 AS day, IFNULL(count(u.id),0) AS number from user u";
//        String suffix = " and u.identity >=40 and u.identity < 60 GROUP BY day) a JOIN (SELECT @totalNumber := 0) s;";
        String prefix = "select b.day as day, b.number as number, (@totalNumber := @totalNumber + b.number) as totalNumber from (select (c.DAY_SHORT_DESC-86400000) as day, IFNULL(a.number,0) as number from calendar c LEFT JOIN (select UNIX_TIMESTAMP(DATE_FORMAT(FROM_UNIXTIME(u.start_at/1000), '%Y-%m-%d'))*1000 AS day, IFNULL(count(u.id),0) AS number from user u";
        String suffix = " and u.identity >=40 and u.identity < 60 GROUP BY day) a on a.day = (c.DAY_SHORT_DESC - 86400000) where (c.DAY_SHORT_DESC-86400000) < (UNIX_TIMESTAMP(NOW())*1000) and c.DAY_SHORT_DESC > 0)b JOIN (select @totalNumber := 0) s;";

        if (StringUtils.isNotEmpty(school) || StringUtils.isNotEmpty(place) || StringUtils.isNotEmpty(major) || DataUtils.isNotNullOrEmpty(grade)) {
            sb.append(prefix + ", record r where r.uid = u.id ");
            if (StringUtils.isNotEmpty(school)) {
                sb.append(" and r.school like CONCAT('%',?,'%')");
                objectList.add(school);
            }
            if (StringUtils.isNotEmpty(place)) {
                sb.append(" and CONCAT(r.province,r.city,r.county) like CONCAT('%',?,'%')");
                objectList.add(place);
            }
            if (StringUtils.isNotEmpty(major)) {
                sb.append(" and r.major like CONCAT('%',?,'%')");
                objectList.add(major);
            }
            if (DataUtils.isNotNullOrEmpty(grade)) {
                sb.append(" and r.grade = ?");
                objectList.add(grade);
            }

        } else {
            sb.append(prefix + " where 1 = 1");
        }

        if (DataUtils.isNotNullOrEmpty(occupationId)) {
            sb.append(" and u.oid = ?");
            objectList.add(occupationId);
        }
        if (DataUtils.isNotNullOrEmpty(age)) {
            if (age.equals(0)) { //年龄不限
                sb.append("");
            }
            if (age.equals(1)) { //年龄<18
                sb.append(" and TIMESTAMPDIFF(year, FROM_UNIXTIME(birthday/1000), CURRENT_TIMESTAMP()) < 18");
            }
            if (age.equals(2)) { //年龄>=18,<=24
                sb.append(" and TIMESTAMPDIFF(year, FROM_UNIXTIME(birthday/1000), CURRENT_TIMESTAMP()) >= 18 and TIMESTAMPDIFF(year, FROM_UNIXTIME(birthday/1000), CURRENT_TIMESTAMP()) <= 24");
            }
            if (age.equals(3)) { //年龄>=24,<=30
                sb.append(" and TIMESTAMPDIFF(year, FROM_UNIXTIME(birthday/1000), CURRENT_TIMESTAMP()) >= 25 and TIMESTAMPDIFF(year, FROM_UNIXTIME(birthday/1000), CURRENT_TIMESTAMP()) < 30");
            }
            if (age.equals(4)) { //年龄>30
                sb.append(" and TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) > 30");
            }
        }
        if (DataUtils.isNotNullOrEmpty(minStartAt)) {
            sb.append(" and u.start_at >= ?");
            objectList.add(minStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(maxStartAt)) {
            sb.append(" and u.start_at <= ?");
            objectList.add(maxStartAt);
        }

        sb.append(suffix);

        log.info("query by sql: [" + sb.toString() + "]");
        log.info("execute query sql by params: " + objectList);

        return template.query(sb.toString(), new BeanPropertyRowMapper<>(InDoorStudentStatistics.class), objectList.toArray());
    }

    //22期 - 档案管理 - 按条件展示饼图
    @Override
    public List<InDoorStudentStatistics> getPieCharByParams(Long minPassAt, Long maxPassAt, Long minStartAt, Long maxStartAt, Long minGraduateAt, Long maxGraduateAt, Integer occupationId, Integer condition) {

        StringBuffer sb = new StringBuffer();
        List<Object> objectList = new ArrayList<>();

        String prefix = "";
        String suffix = "";

        if(ObjectUtils.equals(condition, CONDITION_AGE)) {
            prefix = "select a.item item, count(a.item) number FROM (" +
                    "select case when TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) <18 then '18岁以下' "
                    + "when TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) >= 18 and TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) <= 24 then '18~24岁' "
                    + "when TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) >= 25 and TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) < 30 then '25~30岁' "
                    + "when TIMESTAMPDIFF(year, FROM_UNIXTIME(born_at/1000), CURRENT_TIMESTAMP()) >= 30 then '30岁以上' "
                    + "end as item from record r";
            suffix = "r.status = 3) a group by a.item ORDER BY number desc limit 0, 10;";
        } else if (ObjectUtils.equals(condition, CONDITION_CITY)) {
            prefix = "select case d.city when -1 then '未知' when -1-1 then '未知' else d.city end as item, count(d.city) number from " +
                    "(select SUBSTRING_INDEX(c.city,'省',-1) city from " +
                    "(select SUBSTRING_INDEX(b.city,'自治区',-1) city from " +
                    "(select SUBSTRING_INDEX(CONCAT(a.city),'市辖区',1) city from " +
                    "(select SUBSTRING_INDEX(CONCAT(r.province, r.city),'县',1) city from " +
                    "record r";
            suffix = "r.status = 3) a) b) c) d group by city order by number desc limit 0, 10;";
        } else if (ObjectUtils.equals(condition, CONDITION_GRADE)) {
            prefix = "select case r.grade " +
                    "when -1 then '未知' " +
                    "when 1 then '小学' " +
                    "when 2 then '初中' " +
                    "when 3 then '高中' " +
                    "when 4 then '专科' " +
                    "when 5 then '中专' " +
                    "when 6 then '大专' " +
                    "when 7 then '本科' " +
                    "when 8 then '硕士' " +
                    "when 9 then '博士' " +
                    "end as item, IFNULL(count(r.id), 0) number from record r";
            suffix = "r.status = 3 GROUP BY r.grade;";
        } else if (ObjectUtils.equals(condition, CONDITION_MAJOR)) {
            prefix = "select r.major item, IFNULL(count(r.id), 0) number from record r";
            suffix = "r.grade >= 5 and r.status = 3 GROUP BY r.major ORDER BY number desc limit 0, 10;";
        } else if (ObjectUtils.equals(condition, CONDITION_SCHOOL)) {
            prefix = "select r.school item, IFNULL(count(r.id), 0) number from record r";
            suffix = "r.grade >= 5 and r.status = 3 GROUP BY r.school ORDER BY number desc limit 0, 10;";
        }

        if (StringUtils.isNotEmpty(prefix)) {
            sb.append(prefix);
        }

        if(DataUtils.isNotNullOrEmpty(occupationId) || DataUtils.isNotNullOrEmpty(minStartAt) || DataUtils.isNotNullOrEmpty(maxGraduateAt)
                || DataUtils.isNotNullOrEmpty(minGraduateAt) || DataUtils.isNotNullOrEmpty(maxGraduateAt)) {
            sb.append(", user u where u.id = r.uid and ");
        } else {
            sb.append(" where ");
        }

        if (DataUtils.isNotNullOrEmpty(minPassAt) || DataUtils.isNotNullOrEmpty(maxPassAt)) {
            if (DataUtils.isNotNullOrEmpty(minPassAt)) {
                sb.append(" r.update_at >= ? and ");
                objectList.add(minPassAt);
            }
            if (DataUtils.isNotNullOrEmpty(maxPassAt)) {
                sb.append(" r.update_at <= ? and ");
                objectList.add(maxPassAt);
            }
        }

        if (DataUtils.isNotNullOrEmpty(occupationId)) {
            sb.append(" u.oid = ? and r.uid = u.id and ");
            objectList.add(occupationId);
        }

        if (DataUtils.isNotNullOrEmpty(minStartAt)) {
            sb.append(" u.start_at >= ? and ");
            objectList.add(minStartAt);
        }

        if (DataUtils.isNotNullOrEmpty(maxStartAt)) {
            sb.append(" u.start_at <= ? and ");
            objectList.add(maxStartAt);
        }

        if (DataUtils.isNotNullOrEmpty(minGraduateAt)) {
            sb.append(" u.graduate_at >= ? and ");
            objectList.add(minGraduateAt);
        }

        if (DataUtils.isNotNullOrEmpty(maxGraduateAt)) {
            sb.append(" u.graduate_at <= ? and ");
            objectList.add(maxGraduateAt);
        }


        if (StringUtils.isNotEmpty(suffix)) {
            sb.append(suffix);
        }

        log.info("query by sql: [" + sb.toString() + "]");
        log.info("execute query sql by params: " + objectList);

        return template.query(sb.toString(), new BeanPropertyRowMapper<>(InDoorStudentStatistics.class), objectList.toArray());
    }

    //22期 - 档案管理 - 根据档案状态计算档案总数
    @Override
    public Integer getRecordTotalNumber(Integer status) {

        StringBuffer sb = new StringBuffer();
        List<Object> objectList = new ArrayList<>();

        sb.append("select count(id) number from record");

        if (DataUtils.isNotNullOrEmpty(status) && status >= Record.STATUS_UNCOMMITTED && status <= Record.STATUS_NO_PASS) {
            sb.append(" where status = ? ");
            objectList.add(status);
        }

        sb.append(";");
        log.info("count record total number by sql: [" + sb.toString() + "]");
        log.info("count record total number by params: " + objectList);

        return template.query(sb.toString(), new BeanPropertyRowMapper<>(InDoorStudentStatistics.class), objectList.toArray()).get(0).getNumber();
    }

    @Override
    public Long getProvinceIdByProvince(String province) {

        String sql = "select province_id from provinces where province = ?;";

        return template.query(sql, new BeanPropertyRowMapper<>(Provinces.class), province).get(0).getProvinceId();
    }

    @Override
    public Long getCityIdByCity(String city) {

        String sql = "select city_id from cities where city = ?;";

        return template.query(sql, new BeanPropertyRowMapper<>(Cities.class), city).get(0).getCityId();
    }

    @Override
    public Long getCountyIdByCounty(String county, Long cityId) {

        List<Object> objectList = new ArrayList<>();

        String sql = "select county_id from counties where county = ? and city_id = ?;";

        objectList.add(county);
        objectList.add(cityId);

        return template.query(sql, new BeanPropertyRowMapper<>(Counties.class), objectList.toArray()).get(0).getCountyId();
    }

}
