/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Major;
import com.ptteng.common.skill.service.MajorService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MajorServiceImpl
extends BaseDaoServiceImpl
implements MajorService {
    private static final Log log = LogFactory.getLog(MajorServiceImpl.class);

    public Long insert(Major major) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + major));
        if (major == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        major.setCreateAt(Long.valueOf(currentTimeMillis));
        major.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)major);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + major));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Major> insertList(List<Major> majorList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (majorList == null ? "null" : Integer.valueOf(majorList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(majorList)) {
            return new ArrayList<Major>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Major major : majorList) {
            major.setCreateAt(Long.valueOf(currentTimeMillis));
            major.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(majorList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + majorList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Major.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Major major) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (major == null ? "null" : major.getId())));
        boolean result = false;
        if (major == null) {
            return true;
        }
        major.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)major);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + major));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + major));
        }
        return result;
    }

    public boolean updateList(List<Major> majorList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (majorList == null ? "null" : Integer.valueOf(majorList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(majorList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Major major : majorList) {
            major.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(majorList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + majorList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + majorList.size()));
        return result;
    }

    public Major getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Major major = null;
        if (id == null) {
            return major;
        }
        try {
            major = (Major)this.dao.get(Major.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return major;
    }

    public List<Major> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List major = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Major>();
        }
        try {
            major = this.dao.getList(Major.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (major == null ? "null" : Integer.valueOf(major.size()))));
        return major;
    }

    public List<Long> getMajorIdsByPrimaryMajor(String primaryMajor, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by primaryMajor,start,limit  : " + primaryMajor + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMajorIdsByPrimaryMajor", new Object[]{primaryMajor}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by primaryMajor,start,limit)  : " + primaryMajor + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getMajorIdsByMajor(String major, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by major,start,limit  : " + major + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMajorIdsByMajor", new Object[]{major}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by major,start,limit)  : " + major + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getMajorIdsBySecondryMajor(String secondryMajor, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by secondryMajor,start,limit  : " + secondryMajor + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMajorIdsBySecondryMajor", new Object[]{secondryMajor}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by secondryMajor,start,limit)  : " + secondryMajor + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countMajorIdsByPrimaryMajor(String primaryMajor) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by primaryMajor  : " + primaryMajor));
        }
        Integer count = null;
        try {
            count = this.dao.count("getMajorIdsByPrimaryMajor", new Object[]{primaryMajor});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by primaryMajor)  : " + primaryMajor));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countMajorIdsByMajor(String major) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by major  : " + major));
        }
        Integer count = null;
        try {
            count = this.dao.count("getMajorIdsByMajor", new Object[]{major});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by major)  : " + major));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countMajorIdsBySecondryMajor(String secondryMajor) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by secondryMajor  : " + secondryMajor));
        }
        Integer count = null;
        try {
            count = this.dao.count("getMajorIdsBySecondryMajor", new Object[]{secondryMajor});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by secondryMajor)  : " + secondryMajor));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getMajorIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getMajorIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countMajorIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getMajorIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getMajorIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

