/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Comment;
import com.ptteng.common.skill.service.CommentService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommentServiceImpl
extends BaseDaoServiceImpl
implements CommentService {
    private static final Log log = LogFactory.getLog(CommentServiceImpl.class);

    public Long insert(Comment comment) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + comment));
        if (comment == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        comment.setCreateAt(Long.valueOf(currentTimeMillis));
        comment.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)comment);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + comment));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Comment> insertList(List<Comment> commentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (commentList == null ? "null" : Integer.valueOf(commentList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(commentList)) {
            return new ArrayList<Comment>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Comment comment : commentList) {
            comment.setCreateAt(Long.valueOf(currentTimeMillis));
            comment.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(commentList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + commentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Comment.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Comment comment) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (comment == null ? "null" : comment.getId())));
        boolean result = false;
        if (comment == null) {
            return true;
        }
        comment.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)comment);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + comment));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + comment));
        }
        return result;
    }

    public boolean updateList(List<Comment> commentList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (commentList == null ? "null" : Integer.valueOf(commentList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(commentList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Comment comment : commentList) {
            comment.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(commentList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + commentList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + commentList.size()));
        return result;
    }

    public Comment getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Comment comment = null;
        if (id == null) {
            return comment;
        }
        try {
            comment = (Comment)this.dao.get(Comment.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return comment;
    }

    public List<Comment> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List comment = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Comment>();
        }
        try {
            comment = this.dao.getList(Comment.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (comment == null ? "null" : Integer.valueOf(comment.size()))));
        return comment;
    }

    public List<Long> getCommentIdsByDid(Long did, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by did,start,limit  : " + did + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCommentIdsByDid", new Object[]{did}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by did,start,limit)  : " + did + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getLastCommentIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLastCommentIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCommentIdsByDid(Long did) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by did  : " + did));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCommentIdsByDid", new Object[]{did});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by did)  : " + did));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getCommentIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCommentIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCommentIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCommentIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCommentIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

