/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Teacher;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.TeacherService;
import com.qding.common.util.DataUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TeacherServiceImpl
extends BaseDaoServiceImpl
implements TeacherService {
    private static final Log log = LogFactory.getLog(TeacherServiceImpl.class);

    public Long insert(Teacher teacher) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + teacher));
        if (teacher == null) {
            return null;
        }
        if (teacher.getId() == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        teacher.setCreateAt(Long.valueOf(currentTimeMillis));
        teacher.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)teacher);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + teacher));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Teacher> insertList(List<Teacher> teacherList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (teacherList == null ? "null" : Integer.valueOf(teacherList.size()))));
        ArrayList<Teacher> teachers = new ArrayList<Teacher>();
        List resultList = null;
        if (CollectionUtils.isEmpty(teacherList)) {
            return new ArrayList<Teacher>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Teacher teacher : teacherList) {
            if (teacher.getId() != null) {
                teacher.setCreateAt(Long.valueOf(currentTimeMillis));
                teacher.setUpdateAt(Long.valueOf(currentTimeMillis));
                teachers.add(teacher);
                continue;
            }
            log.info((Object)("teacher`id is null:" + teacher));
        }
        try {
            resultList = this.dao.batchSave(teachers);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + teacherList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Teacher.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Teacher teacher) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (teacher == null ? "null" : teacher.getId())));
        boolean result = false;
        if (teacher == null) {
            return true;
        }
        teacher.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)teacher);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + teacher));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + teacher));
        }
        return result;
    }

    public boolean updateList(List<Teacher> teacherList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (teacherList == null ? "null" : Integer.valueOf(teacherList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(teacherList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Teacher teacher : teacherList) {
            teacher.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(teacherList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + teacherList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + teacherList.size()));
        return result;
    }

    public Teacher getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Teacher teacher = null;
        if (id == null) {
            return teacher;
        }
        try {
            teacher = (Teacher)this.dao.get(Teacher.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return teacher;
    }

    public List<Teacher> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List teacher = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Teacher>();
        }
        try {
            teacher = this.dao.getList(Teacher.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (teacher == null ? "null" : Integer.valueOf(teacher.size()))));
        return teacher;
    }

    public List<Long> getTeacherIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTeacherIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTeacherIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getTeacherIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getTeacherIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public void dropTeacherRelationToStundent(List<User> students, Long teacherId) throws ServiceException, ServiceDaoException {
        try {
            log.info((Object)(" dropTeacherRelationToStundent ,teacherId = " + teacherId));
            Teacher teacher = null;
            if (!DataUtils.isNotNullOrEmpty((Object)teacherId)) {
                log.info((Object)" oldTeacherId is null, don`t need dropTeacherRelation ");
                return;
            }
            teacher = this.getObjectById(teacherId);
            log.info((Object)(" oldTeacher detail :" + teacher));
            for (User student : students) {
                log.info((Object)(" student " + student.getId() + " dropTeacherRelationToStundent "));
                if (!DataUtils.isNotNullOrEmpty((Object)teacher) || !DataUtils.isNotNullOrEmpty((Object)student)) continue;
                Integer studentIdentify = student.getIdentity();
                if (User.IDENTIFY_20.equals(studentIdentify)) {
                    int onlineNow = teacher.getOnlineNow() - 1;
                    teacher.setOnlineNow(Integer.valueOf(onlineNow));
                    log.info((Object)"update teacher for removing a online student");
                    continue;
                }
                if (User.IDENTIFY_30.equals(studentIdentify)) {
                    int outlineNow = teacher.getOutlineNow() - 1;
                    teacher.setOutlineTotal(Integer.valueOf(outlineNow));
                    log.info((Object)"update teacher for removing a outline student");
                    continue;
                }
                if (User.IDENTIFY_40.equals(studentIdentify)) {
                    int offlineNow = teacher.getOfflineNow() - 1;
                    teacher.setOfflineNow(Integer.valueOf(offlineNow));
                    log.info((Object)"update teacher for removing a offline student");
                    continue;
                }
                if (User.IDENTIFY_50.equals(studentIdentify)) {
                    int chefNow = teacher.getChefNow() - 1;
                    teacher.setChefNow(Integer.valueOf(chefNow));
                    log.info((Object)"update teacher for removing a chef student");
                    continue;
                }
                log.info((Object)(student.getId() + " is a unkown studentIdentify"));
            }
            this.update(teacher);
        }
        catch (Exception t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"update teacher error ");
        }
    }

    public void addTeacherRelationToStundent(User student, Long teacherId) throws ServiceException, ServiceDaoException {
        log.info((Object)(" dropTeacherRelationToStundent ,students = " + student.getId()));
        log.info((Object)(" dropTeacherRelationToStundent ,teacherId = " + teacherId));
        Teacher teacher = this.getObjectById(teacherId);
        try {
            if (DataUtils.isNotNullOrEmpty((Object)teacher) && DataUtils.isNotNullOrEmpty((Object)student)) {
                Integer studentIdentify = student.getIdentity();
                if (User.IDENTIFY_20.equals(studentIdentify)) {
                    int onlineNow = teacher.getOnlineNow() + 1;
                    int onlineTotal = teacher.getOnlineTotal() + 1;
                    teacher.setOnlineNow(Integer.valueOf(onlineNow));
                    teacher.setOnlineTotal(Integer.valueOf(onlineTotal));
                    log.info((Object)"update teacher for adding a online student");
                } else if (User.IDENTIFY_30.equals(studentIdentify)) {
                    int outlineNow = teacher.getOutlineNow() + 1;
                    int outlintTotal = teacher.getOutlineTotal() + 1;
                    teacher.setOutlineNow(Integer.valueOf(outlineNow));
                    teacher.setOutlineTotal(Integer.valueOf(outlintTotal));
                    log.info((Object)"update teacher for adding a outline student");
                } else if (User.IDENTIFY_40.equals(studentIdentify)) {
                    int offlineNow = teacher.getOfflineNow() + 1;
                    int offlineTotal = teacher.getOfflineTotal() + 1;
                    teacher.setOfflineNow(Integer.valueOf(offlineNow));
                    teacher.setOfflineTotal(Integer.valueOf(offlineTotal));
                    log.info((Object)"update teacher for adding a offline student");
                } else if (User.IDENTIFY_50.equals(studentIdentify)) {
                    int chefNow = teacher.getChefNow() + 1;
                    int chefTotal = teacher.getChefTotal() + 1;
                    teacher.setChefNow(Integer.valueOf(chefNow));
                    teacher.setChefTotal(Integer.valueOf(chefTotal));
                    log.info((Object)"update teacher for adding a chef student");
                } else {
                    log.info((Object)(student.getId() + " is a unkown studentIdentify"));
                }
                this.update(teacher);
            }
        }
        catch (Exception t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"update teacher error ");
        }
    }

    public void addTeacherRelationToStundents(List<User> students, Long teacherId) throws ServiceException, ServiceDaoException {
        log.info((Object)" addTeacherRelationToStundents start ... ");
        log.info((Object)(" addTeacherRelationToStundents ,teacherId = " + teacherId));
        Teacher teacher = this.getObjectById(teacherId);
        try {
            if (DataUtils.isNotNullOrEmpty((Object)teacher) && CollectionUtils.isNotEmpty(students)) {
                for (User student : students) {
                    log.info((Object)(" student " + student.getId() + " addTeacherRelationToStundents "));
                    Integer studentIdentify = student.getIdentity();
                    if (User.IDENTIFY_20.equals(studentIdentify)) {
                        int onlineNow = teacher.getOnlineNow() + 1;
                        int onlineTotal = teacher.getOnlineTotal() + 1;
                        teacher.setOnlineNow(Integer.valueOf(onlineNow));
                        teacher.setOnlineTotal(Integer.valueOf(onlineTotal));
                        log.info((Object)"update teacher for adding a online student");
                        continue;
                    }
                    if (User.IDENTIFY_30.equals(studentIdentify)) {
                        int outlineNow = teacher.getOutlineNow() + 1;
                        int outlintTotal = teacher.getOutlineTotal() + 1;
                        teacher.setOutlineNow(Integer.valueOf(outlineNow));
                        teacher.setOutlineTotal(Integer.valueOf(outlintTotal));
                        log.info((Object)"update teacher for adding a outline student");
                        continue;
                    }
                    if (User.IDENTIFY_40.equals(studentIdentify)) {
                        int offlineNow = teacher.getOfflineNow() + 1;
                        int offlineTotal = teacher.getOfflineTotal() + 1;
                        teacher.setOfflineNow(Integer.valueOf(offlineNow));
                        teacher.setOfflineTotal(Integer.valueOf(offlineTotal));
                        log.info((Object)"update teacher for adding a offline student");
                        continue;
                    }
                    if (User.IDENTIFY_50.equals(studentIdentify)) {
                        int chefNow = teacher.getChefNow() + 1;
                        int chefTotal = teacher.getChefTotal() + 1;
                        teacher.setChefNow(Integer.valueOf(chefNow));
                        teacher.setChefTotal(Integer.valueOf(chefTotal));
                        log.info((Object)"update teacher for adding a offline student");
                        continue;
                    }
                    log.info((Object)(student.getId() + " is a unkown studentIdentify"));
                }
                this.update(teacher);
            }
        }
        catch (Exception t) {
            t.printStackTrace();
            log.error((Object)t.getMessage());
            log.error((Object)"update teacher error ");
        }
    }
}

