/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Stage;
import com.ptteng.common.skill.service.StageService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StageServiceImpl
extends BaseDaoServiceImpl
implements StageService {
    private static final Log log = LogFactory.getLog(StageServiceImpl.class);

    public Long insert(Stage stage) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + stage));
        if (stage == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        stage.setCreateAt(Long.valueOf(currentTimeMillis));
        stage.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)stage);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + stage));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Stage> insertList(List<Stage> stageList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (stageList == null ? "null" : Integer.valueOf(stageList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(stageList)) {
            return new ArrayList<Stage>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Stage stage : stageList) {
            stage.setCreateAt(Long.valueOf(currentTimeMillis));
            stage.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(stageList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + stageList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Stage.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Stage stage) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (stage == null ? "null" : stage.getId())));
        boolean result = false;
        if (stage == null) {
            return true;
        }
        stage.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)stage);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + stage));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + stage));
        }
        return result;
    }

    public boolean updateList(List<Stage> stageList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (stageList == null ? "null" : Integer.valueOf(stageList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(stageList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Stage stage : stageList) {
            stage.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(stageList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + stageList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + stageList.size()));
        return result;
    }

    public Stage getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Stage stage = null;
        if (id == null) {
            return stage;
        }
        try {
            stage = (Stage)this.dao.get(Stage.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return stage;
    }

    public List<Stage> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List stage = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Stage>();
        }
        try {
            stage = this.dao.getList(Stage.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (stage == null ? "null" : Integer.valueOf(stage.size()))));
        return stage;
    }

    public List<Long> getStageIdsByOidOrderBySort(Long oid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by oid,start,limit  : " + oid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStageIdsByOidOrderBySort", new Object[]{oid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by oid,start,limit)  : " + oid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStageIdsByOidOrderBySort(Long oid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by oid  : " + oid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getStageIdsByOidOrderBySort", new Object[]{oid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by oid)  : " + oid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getStageIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getStageIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countStageIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getStageIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getStageIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

