package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Stage;
import com.ptteng.common.skill.service.StageService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class StageServiceImpl extends BaseDaoServiceImpl implements StageService {

 

	private static final Log log = LogFactory.getLog(StageServiceImpl.class);



		   
		@Override
		public Long insert(Stage stage)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + stage);

		if (stage == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		stage.setCreateAt(currentTimeMillis);
		stage.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(stage);
		} catch (DaoException e) {
			log.error(" insert wrong : " + stage);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Stage> insertList(List<Stage> stageList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (stageList == null ? "null" : stageList.size()));
      
		List<Stage> resultList = null;

		if (CollectionUtils.isEmpty(stageList)) {
			return new ArrayList<Stage>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Stage stage : stageList) {
			stage.setCreateAt(currentTimeMillis);
			stage.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Stage>) dao.batchSave(stageList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + stageList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Stage.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Stage stage)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (stage == null ? "null" : stage.getId()));

		boolean result = false;

		if (stage == null) {
			return true;
		}

		stage.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(stage);
		} catch (DaoException e) {
			log.error(" update wrong : " + stage);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + stage);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Stage> stageList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (stageList == null ? "null" : stageList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(stageList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Stage stage : stageList) {
			stage.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(stageList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + stageList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + stageList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Stage getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Stage stage = null;

		if (id == null) {
			return stage;
		}

		try {
			stage = (Stage) dao.get(Stage.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return stage;		
		}	
		  
    	   
		@Override
		public List<Stage> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Stage> stage = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Stage>();
		}

		try {
			stage = (List<Stage>) dao.getList(Stage.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (stage == null ? "null" : stage.size()));
    
		return stage;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getStageIdsByOidOrderBySort(Long oid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by oid,start,limit  : " + oid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getStageIdsByOidOrderBySort", new Object[] { oid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by oid,start,limit)  : " + oid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countStageIdsByOidOrderBySort(Long oid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by oid  : " + oid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getStageIdsByOidOrderBySort", new Object[] { oid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by oid)  : " + oid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getStageIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getStageIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countStageIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getStageIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getStageIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

