/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.UserScore;
import com.ptteng.common.skill.service.UserScoreService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserScoreServiceImpl
extends BaseDaoServiceImpl
implements UserScoreService {
    private static final Log log = LogFactory.getLog(UserScoreServiceImpl.class);

    public Long insert(UserScore userScore) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userScore));
        if (userScore == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userScore.setCreateAt(Long.valueOf(currentTimeMillis));
        userScore.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userScore);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userScore));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserScore> insertList(List<UserScore> userScoreList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userScoreList == null ? "null" : Integer.valueOf(userScoreList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userScoreList)) {
            return new ArrayList<UserScore>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserScore userScore : userScoreList) {
            userScore.setCreateAt(Long.valueOf(currentTimeMillis));
            userScore.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userScoreList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userScoreList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserScore.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserScore userScore) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userScore == null ? "null" : userScore.getId())));
        boolean result = false;
        if (userScore == null) {
            return true;
        }
        userScore.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userScore);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userScore));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userScore));
        }
        return result;
    }

    public boolean updateList(List<UserScore> userScoreList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userScoreList == null ? "null" : Integer.valueOf(userScoreList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userScoreList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserScore userScore : userScoreList) {
            userScore.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userScoreList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userScoreList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userScoreList.size()));
        return result;
    }

    public UserScore getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserScore userScore = null;
        if (id == null) {
            return userScore;
        }
        try {
            userScore = (UserScore)this.dao.get(UserScore.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userScore;
    }

    public List<UserScore> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userScore = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserScore>();
        }
        try {
            userScore = this.dao.getList(UserScore.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userScore == null ? "null" : Integer.valueOf(userScore.size()))));
        return userScore;
    }

    public List<Long> getUserScoreIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserScoreIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserScoreIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserScoreIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserScoreIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserScoreIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserScoreIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserScoreIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserScoreIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

