/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Qa;
import com.ptteng.common.skill.service.QaService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QaServiceImpl
extends BaseDaoServiceImpl
implements QaService {
    private static final Log log = LogFactory.getLog(QaServiceImpl.class);

    public Long insert(Qa qa) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + qa));
        if (qa == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        qa.setCreateAt(Long.valueOf(currentTimeMillis));
        qa.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)qa);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + qa));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Qa> insertList(List<Qa> qaList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (qaList == null ? "null" : Integer.valueOf(qaList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(qaList)) {
            return new ArrayList<Qa>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Qa qa : qaList) {
            qa.setCreateAt(Long.valueOf(currentTimeMillis));
            qa.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(qaList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + qaList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Qa.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Qa qa) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (qa == null ? "null" : qa.getId())));
        boolean result = false;
        if (qa == null) {
            return true;
        }
        qa.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)qa);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + qa));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + qa));
        }
        return result;
    }

    public boolean updateList(List<Qa> qaList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (qaList == null ? "null" : Integer.valueOf(qaList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(qaList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Qa qa : qaList) {
            qa.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(qaList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + qaList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + qaList.size()));
        return result;
    }

    public Qa getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Qa qa = null;
        if (id == null) {
            return qa;
        }
        try {
            qa = (Qa)this.dao.get(Qa.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return qa;
    }

    public List<Qa> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List qa = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Qa>();
        }
        try {
            qa = this.dao.getList(Qa.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (qa == null ? "null" : Integer.valueOf(qa.size()))));
        return qa;
    }

    public List<Long> getQaIdsByOidAndTid(Long oid, Long tid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by oid,tid,start,limit  : " + oid + " , " + tid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getQaIdsByOidAndTid", new Object[]{oid, tid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by oid,tid,start,limit)  : " + oid + " , " + tid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countQaIdsByOidAndTid(Long oid, Long tid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by oid,tid  : " + oid + " , " + tid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getQaIdsByOidAndTid", new Object[]{oid, tid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by oid,tid)  : " + oid + " , " + tid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getQaIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getQaIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countQaIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getQaIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getQaIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

