/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.service.OccupationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OccupationServiceImpl
extends BaseDaoServiceImpl
implements OccupationService {
    private static final Log log = LogFactory.getLog(OccupationServiceImpl.class);

    public Long insert(Occupation occupation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + occupation));
        if (occupation == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        occupation.setCreateAt(Long.valueOf(currentTimeMillis));
        occupation.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)occupation);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + occupation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Occupation> insertList(List<Occupation> occupationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (occupationList == null ? "null" : Integer.valueOf(occupationList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(occupationList)) {
            return new ArrayList<Occupation>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Occupation occupation : occupationList) {
            occupation.setCreateAt(Long.valueOf(currentTimeMillis));
            occupation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(occupationList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + occupationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Occupation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Occupation occupation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (occupation == null ? "null" : occupation.getId())));
        boolean result = false;
        if (occupation == null) {
            return true;
        }
        occupation.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)occupation);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + occupation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + occupation));
        }
        return result;
    }

    public boolean updateList(List<Occupation> occupationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (occupationList == null ? "null" : Integer.valueOf(occupationList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(occupationList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Occupation occupation : occupationList) {
            occupation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(occupationList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + occupationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + occupationList.size()));
        return result;
    }

    public Occupation getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Occupation occupation = null;
        if (id == null) {
            return occupation;
        }
        try {
            occupation = (Occupation)this.dao.get(Occupation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return occupation;
    }

    public List<Occupation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List occupation = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Occupation>();
        }
        try {
            occupation = this.dao.getList(Occupation.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (occupation == null ? "null" : Integer.valueOf(occupation.size()))));
        return occupation;
    }

    public Long getOccupationIdByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name  : " + name));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getOccupationIdByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getOccupationIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOccupationIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOccupationIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getOccupationIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getOccupationIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

