package com.ptteng.skill.service.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.skill.service.model.UserTaskRelation;
import com.ptteng.skill.service.service.UserTaskRelationService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserTaskRelationServiceImpl extends BaseDaoServiceImpl implements UserTaskRelationService {

 

	private static final Log log = LogFactory.getLog(UserTaskRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserTaskRelation userTaskRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userTaskRelation);

		if (userTaskRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userTaskRelation.setCreateAt(currentTimeMillis);
		userTaskRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userTaskRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userTaskRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserTaskRelation> insertList(List<UserTaskRelation> userTaskRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userTaskRelationList == null ? "null" : userTaskRelationList.size()));
      
		List<UserTaskRelation> resultList = null;

		if (CollectionUtils.isEmpty(userTaskRelationList)) {
			return new ArrayList<UserTaskRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserTaskRelation userTaskRelation : userTaskRelationList) {
			userTaskRelation.setCreateAt(currentTimeMillis);
			userTaskRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserTaskRelation>) dao.batchSave(userTaskRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userTaskRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserTaskRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserTaskRelation userTaskRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userTaskRelation == null ? "null" : userTaskRelation.getId()));

		boolean result = false;

		if (userTaskRelation == null) {
			return true;
		}

		userTaskRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userTaskRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userTaskRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userTaskRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserTaskRelation> userTaskRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userTaskRelationList == null ? "null" : userTaskRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userTaskRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserTaskRelation userTaskRelation : userTaskRelationList) {
			userTaskRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userTaskRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userTaskRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userTaskRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserTaskRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserTaskRelation userTaskRelation = null;

		if (id == null) {
			return userTaskRelation;
		}

		try {
			userTaskRelation = (UserTaskRelation) dao.get(UserTaskRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userTaskRelation;		
		}	
		  
    	   
		@Override
		public List<UserTaskRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserTaskRelation> userTaskRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserTaskRelation>();
		}

		try {
			userTaskRelation = (List<UserTaskRelation>) dao.getList(UserTaskRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userTaskRelation == null ? "null" : userTaskRelation.size()));
    
		return userTaskRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getUserTaskRelationIdByTidAndUid(Long tid,Long uid)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by tid,uid  : " + tid+" , "+uid );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getUserTaskRelationIdByTidAndUid", new Object[] {tid,uid });
   } catch (DaoException e) {
			log.error(" get id wrong by tid,uid  : " + tid+" , "+uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserTaskRelationIdsByUidAndOid(Long uid,Long oid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,oid,start,limit  : " + uid+" , "+oid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserTaskRelationIdsByUidAndOid", new Object[] { uid,oid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,oid,start,limit)  : " + uid+" , "+oid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserTaskRelationIdsByUidAndOid(Long uid,Long oid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid,oid  : " + uid+" , "+oid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserTaskRelationIdsByUidAndOid", new Object[] { uid,oid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid,oid)  : " + uid+" , "+oid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserTaskRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserTaskRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserTaskRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserTaskRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserTaskRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

	@Override
	public List<Long> getUserTaskRelationIdsByUid(Long uid,Integer start, Integer limit) throws ServiceException, ServiceDaoException {


		if (log.isInfoEnabled()) {
			log.info(" get ids by cid,type,start,limit  : " + " , " + start + " , " + limit);
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserTaskRelationIdsByUid", new Object[]{uid}, start, limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by oid,type,start,limit)  : " + " , " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;


	}

}

