package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;

import com.ptteng.common.skill.model.BranchInstitute;
import com.ptteng.common.skill.service.BranchInstituteService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class BranchInstituteServiceImpl extends BaseDaoServiceImpl implements BranchInstituteService {

 

	private static final Log log = LogFactory.getLog(BranchInstituteServiceImpl.class);



		   
		@Override
		public Long insert(BranchInstitute branchInstitute)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + branchInstitute);

		if (branchInstitute == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		branchInstitute.setCreateAt(currentTimeMillis);
		branchInstitute.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(branchInstitute);
		} catch (DaoException e) {
			log.error(" insert wrong : " + branchInstitute);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<BranchInstitute> insertList(List<BranchInstitute> branchInstituteList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (branchInstituteList == null ? "null" : branchInstituteList.size()));
      
		List<BranchInstitute> resultList = null;

		if (CollectionUtils.isEmpty(branchInstituteList)) {
			return new ArrayList<BranchInstitute>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (BranchInstitute branchInstitute : branchInstituteList) {
			branchInstitute.setCreateAt(currentTimeMillis);
			branchInstitute.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<BranchInstitute>) dao.batchSave(branchInstituteList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + branchInstituteList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(BranchInstitute.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(BranchInstitute branchInstitute)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (branchInstitute == null ? "null" : branchInstitute.getId()));

		boolean result = false;

		if (branchInstitute == null) {
			return true;
		}
		branchInstitute.setUpdateAt(System.currentTimeMillis());
		try {
			result = dao.update(branchInstitute);
		} catch (DaoException e) {
			log.error(" update wrong : " + branchInstitute);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + branchInstitute);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<BranchInstitute> branchInstituteList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (branchInstituteList == null ? "null" : branchInstituteList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(branchInstituteList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (BranchInstitute branchInstitute : branchInstituteList) {
			branchInstitute.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(branchInstituteList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + branchInstituteList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + branchInstituteList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public BranchInstitute getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		BranchInstitute branchInstitute = null;

		if (id == null) {
			return branchInstitute;
		}

		try {
			branchInstitute = (BranchInstitute) dao.get(BranchInstitute.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return branchInstitute;		
		}	
		  
    	   
		@Override
		public List<BranchInstitute> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<BranchInstitute> branchInstitute = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<BranchInstitute>();
		}

		try {
			branchInstitute = (List<BranchInstitute>) dao.getList(BranchInstitute.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (branchInstitute == null ? "null" : branchInstitute.size()));
    
		return branchInstitute;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getBranchInstituteIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getBranchInstituteIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countBranchInstituteIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getBranchInstituteIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getBranchInstituteIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

