package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.google.gson.Gson;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
//import com.ptteng.common.skill.util.OrderStatus;
import com.ptteng.common.skill.util.OrderStatus;
import com.qding.common.pay.model.IndentInfo;
import com.qding.common.pay.service.IndentInfoService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
//import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.jws.soap.SOAPBinding;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by lhwarthas on 16/3/16.
 */
@Service(IndentInfoService.class)
@Component("IndentInfoService")
public class IndentInfoServiceImpl implements IndentInfoService {



//    @Autowired
//    private OrderSkuService orderSkuService;
//
//    @Resource(name = "fundService")
//    private FundService fundService;
//
//    @Resource(name = "userScoreService")
//    private UserScoreService userScoreService;

    @Resource(name = "userService")
    private UserService userService;


    @Resource(name = "accountService")
    private AccountService accountService;


    @Resource(name = "servertService")
    private ServertService servertService;

    @Resource(name = "goodsService")
    private GoodsService goodsService;


    @Resource(name = "orderService")
    private OrderService orderService;


    @Resource(name = "messageService")
    private MessageService messageService;


//    @Resource(name = "skuService")
//    private SkuService skuService;
//
//    @Resource(name = "whiteScoreService")
//    private WhiteScoreService whiteScoreService;
//
//    @Resource(name = "constantService")
//    private ConstantService constantService;
//
//    private DalBaseService<Order> dalBaseOrderService = () -> Order.class;

    private Log log = LogFactory.getLog(IndentInfoServiceImpl.class);

    @Autowired
    private Dao dao;

    @Override
    public String getIndentByIndentCode(String IndentCode) throws ServiceException, ServiceDaoException {


        IndentInfo indentInfo = new IndentInfo();

        log.info("========++++++++++"+IndentCode);
        try {
//            Order order = orderService.getObjectById(Long.parseLong(IndentCode));
              Order order = orderService.getObjectByOrderId(IndentCode);
//            if (86400000 < System.currentTimeMillis() - order.getCreateAt()) {
//                return "100";//订单超时
//            }

            log.info("get order : " + order.toString());
            indentInfo.setGoodsName("账号订单: " + IndentCode);
            indentInfo.setCreateAt(order.getCreateAt());
            indentInfo.setTotalMoney(Double.parseDouble(order.getTotalPrice()));
            indentInfo.setPayManner(order.getPayManner());
            indentInfo.setStatus(order.getStatus());
            indentInfo.setPayAt(order.getPayAt());
            indentInfo.setUserId(order.getBuyer());

        } catch (Exception e) {
            log.info("this is a error"+e);
            log.error(e.getStackTrace());
        }
        Gson gson = new Gson();
        String indentInfoJson = gson.toJson(indentInfo);
        log.info("indentInfoJson : " + indentInfoJson);
        return indentInfoJson;
    }

    @Override
    public void noticeBack(String indentCode, int respCode, int payManner) throws ServiceException, ServiceDaoException {
        try {

            log.info("-=-=-=-=-=-=-=-noticeBack get indentCode : " + indentCode + " and respCode : " + respCode + " and payManner : " + payManner);
//            Order order = orderService.getObjectById(Long.parseLong(indentCode));
           Order order = orderService.getObjectByOrderId(indentCode);

            if (!Integer.valueOf(OrderStatus.WAITFORPAY).equals(order.getStatus())) {
                log.info(" indentinfo  service  status not  waitforpay 2  "+ order.getStatus());
                return;
            }

            log.info("get order : " + order.getName());

            if (order != null){
                log.info("111111111 "+order.getStatus());

                if (order.getStatus() != null){


                    log.info("the order hava status");

                    if("renew".equals(order.getMobile())){ // 说明是续费订单

                        log.info("this is renew order "+order);


                        List<Long> goodids = goodsService.getGoodsByBuyerAndOrderid(order.getBuyer(), order.getOrderId(), 0, Integer.MAX_VALUE);

                        List<Goods> goodses = goodsService.getObjectsByIds(goodids);

                        Goods goods = goodses.get(0);

                        log.info("the goods is" + goods);

                        if (goods.getType() == 2){

                            log.info("the jinshanyun renew");

                        }else{

                            log.info("the goods name is" + goods.getName());
                            Account account = accountService.getObjectById(Long.parseLong(goods.getName()));
                            Long now = System.currentTimeMillis();
                            Long times =0L;
                            //如果这个服务器还没有停止使用，即未过期的情况下进行续费，那么新的endTime就是31天+旧的endTime;
                            //如果这个服务器已经过了到期时间才进行续费，那么新的endTime就是现在的时间+31天
                            if(now >= account.getEndTime()){
                                log.info(" accout has out of date ,last endTime is "+account.getEndTime());
                                times = goods.getCount()*31*24*3600*1000 + now;
                            }else {
                                log.info(" account don't out of date,contine use ,last endTime is "+account.getEndTime());
                                times = goods.getCount()*31*24*3600*1000 + account.getEndTime();
                            }
                            account.setStatus(Account.Status_Using);
                            account.setEndTime(times);
                            account.setOrderId(order.getOrderId());
                            if (account.getNewPwd() != null){
                                account.setPwd(account.getNewPwd());
                                account.setNewPwd(null);
                            }
                            boolean bool = accountService.update(account);

                        }
                        order.setStatus(4);
                        order.setPayAt(System.currentTimeMillis());
                        orderService.update(order);

                       log.info("the add time result");
                        // 发邮件分配账号
                        if (order.getJcount() != 0){

                            order.setStatus(1);
                            boolean bool = orderService.update(order);
                            System.out.println("send to email and update is "+bool);

                        }

                    }else {

                        log.info("update the order status");

                        // 状态是已发货
                        order.setStatus(4);
                        order.setPayAt(System.currentTimeMillis());
                        order.setSendAt(System.currentTimeMillis());
                        boolean isSuccess = orderService.update(order);
                        log.info("ststus is " + isSuccess);

                        // 根据订单获取用户id
                        // 付款之后要给客户分配账号

                        List<Long> goodids = goodsService.getGoodsByBuyerAndOrderid(order.getBuyer(), order.getOrderId(), 0, Integer.MAX_VALUE);

                        List<Goods> goodses = goodsService.getObjectsByIds(goodids);

                        // 自动分配学员账号
                        if (goodids.size() == 0){

                            log.info("the unused account id null");

                        }else {

                            for (Goods goods : goodses){
                                if (goods.getType() == 1){
                                    if(DataUtils.isNullOrEmpty(goods.getGoodCount())){
                                        goods.setGoodCount(1);
                                    }
                                    List<Long> ids = accountService.getAccountByStatusAndType(2,1L,0,goods.getGoodCount());
                                    log.info("=====the account ids is"+ids);
                                    List<Account> accounts = accountService.getObjectsByIds(ids);
                                    for (Account account :accounts){

                                        account.setBuyer(order.getBuyer());
                                        account.setMobile(order.getMobile());
                                        Long times = goods.getCount()*30*24*3600*1000 + System.currentTimeMillis();
                                        account.setBuyTime(System.currentTimeMillis());
                                        account.setEndTime(times);
                                        account.setStatus(Account.Status_Using);
                                        account.setOrderId(order.getOrderId());

                                    }
                                    boolean bool = accountService.updateList(accounts);
                                    log.info("the updateList is "+bool);
                                }else {

                                    log.info("the account is jinshanyun");
                                }


                            }

                            if (order.getCount() != 0){

                                User receiver = userService.getObjectById(order.getBuyer());

                                //存入系统消息
                                Message message = new Message();
                                message.setStatus(1);
                                message.setReceiveName(receiver.getNick());
                                message.setSendName("admin");
                                message.setSendId(0L);
                                message.setContent("");
                                message.setReceiveId(receiver.getId());
                                message.setUnread(1);
                                message.setType(Message.DAILY_TYPE);
//                            message.setRelationId(did);
                                Long mid = messageService.insert(message);

                                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                                String time = df.format(new Date(order.getPayAt()));

                                String content =  "<span  class=\\\"font-16px system-alert-outline\\\">" + "<span class=\\\"font-green\\\">您</span>" +
                                        "<span class=\\\"font-orange\\\" data-mid=" + mid + ">" +time+"</span>" +
                                        "购买的服务器已发货,<a   data-mid=" + mid + " ng-click=\\\"sendAlertMsg(li.id)\\\"  class=\\\"font-green\\\" target=\"_blank\" href=\\\"/school/"+order.getBuyer()+"/account\\\">点击查看</a>" +
                                        "</span>";

                                log.info("user : " + receiver.getMobile() + " send : " + content);
                                adminSend(receiver.getMobile(), content);

                                message = messageService.getObjectById(mid);
                                message.setContent(content);
                                log.info("message is " + message);

                                Boolean result = messageService.update(message);
                                log.info("result is " + result);

                                // 获取用户,更改用户查看消息列表的状态
                                receiver.setIsLook(receiver.getIsLook()+1);
                                receiver.setLatestMsg(Message.DAILY_TYPE);
                                userService.update(receiver);

                            }
                        }
                        // 发邮件分配账号
                        if (order.getJcount() != 0){

                            order.setStatus(1);
                           boolean bool = orderService.update(order);
                            System.out.println("send to email and update is "+bool);

                        }
                    }
                }




            }
        }catch (Exception e){

            log.info("the error is " + e);
        }

    }


    public static String adminSend(String mobile, String content) {


        String param = "{\n" +
                "    \"target_type\" : \"users\", \n" +
                "    \"target\" : [\"" + mobile + "\"],   \n" +
                "                                   \n" +
                "                                   \n" +
                "    \"msg\" : {\n" +
                "        \"type\" : \"txt\",\n" +
                "        \"msg\" : \"" + content + "\" \n" +
                "        },\n" +
                "    \"from\" : \"admin\"\n" +
                "}";
        String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");

        return result;
    }


    /**
     * 提现回调
     * @param fundId
     * @param userId
     * @param income
     * @param respCode
     * @throws ServiceException
     * @throws ServiceDaoException
     */

    @Override
    public void paymentStatus(Long fundId,Long userId, Double income, int respCode) throws ServiceException, ServiceDaoException {
//       Fund fund = fundService.get(fundId);
//        Long userScoreId = (Long) userScoreService.getUser(new Object[]{userId});
//        UserScore userScore = userScoreService.get(userScoreId);
//       switch (respCode) {
//            case IndentUtil.PAY_SUCCESS://提现成功
//                //改状态就行
//                fund.setstatus(Fund.STATUS_4);
//                fund.setleftFund(userScore.getfund());
//                fund.setUpdateAt(System.currentTimeMillis());
//                Boolean changeFundStatus =  fundService.update(fund);
//                log.info(" payment success  changeFundStatus = "+changeFundStatus);
//                break;
//
//            case IndentUtil.PAY_FAIL:         //提现失败
//                log.info(" payment failure result   ");
//                //step 1:提现失败，状态为5，
//                fund.setstatus(Fund.STATUS_5);
//                fund.setleftFund(userScore.getfund());
//                fund.setUpdateAt(System.currentTimeMillis());
//                Boolean updateFund  =  fundService.update(fund);
//                log.info("  updateFund = "+updateFund);
//                //step 2:提现失败回滚余额，增加一条余额记录，交易类型=退款
//                Boolean addFund =  fundService.changeFund
//                    (userId,income, WhiteScore.INCOMEFLAG_1, Fund.DEALTYPE_5, Fund.PAYUSER_1, 0L, Fund.STATUS_6);
//                log.info(" addFund result  = "+addFund);
//                break;
//        }

    }

    @Override
    public Boolean AliPayStatusQuery(String orderId) {

        boolean bRes = false;
//
//        String out_trade_no = orderId.toString();
//
//        Map<String, String> sParaTemp = new java.util.HashMap<String, String>();
//
//        sParaTemp.put("service", "single_trade_query");
//        sParaTemp.put("partner", AlipayConfig.partner);
//        sParaTemp.put("_input_charset", AlipayConfig.input_charset);
//        sParaTemp.put("out_trade_no", out_trade_no);
//
//        String sHtmlText = null;
//        try {
//            sHtmlText = AlipaySubmit.buildRequest("", "", sParaTemp);
//            log.info("get alipay query response xml : " + sHtmlText);
//        } catch (Exception e) {
//            e.printStackTrace();
//            return false;
//        }
//
//        Document document = null;
//
//        try {
//            document = DocumentHelper.parseText(sHtmlText);
//        } catch (DocumentException e) {
//            e.printStackTrace();
//            return false;
//        }
//
//        Element root = document.getRootElement();
//        Element isSuccess = root.element("is_success");
//        if (isSuccess.getText().equals("T")) {
//            Order order = orderService.getOrderObjectByOrderId(new Object[]{orderId});
//            Element response = root.element("response");
//            Element trade = response.element("trade");
//
//            Element tradeStatus = trade.element("trade_status");
//            if (tradeStatus.getText().equals("TRADE_SUCCESS")) {
//                Element price = trade.element("price");
//                Double priceD = new Double(price.getText());
//                if (priceD.equals(order.getRealPay())) {
//                    /*
//                    * 订单支付成功
//                    * 此处写更改订单状态的逻辑
//                    * */
//
//                    /*Element paymentTime = trade.element("gmt_payment");
//                    System.out.println(paymentTime.getText());
//                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//                    Date date = null;
//                    try {
//                        date = format.parse(paymentTime.getText());
//                    } catch (ParseException e) {
//                        e.printStackTrace();
//                    }
//
//                    order.setDealTime(date.getTime());
//                    order.setStatus(OrderStatus.WAITFORDELIVER);
//                    orderService.update(order);*/
//
//                    bRes = true;
//                    try {
//                        noticeBack(orderId, IndentUtil.PAY_SUCCESS, IndentUtil.PAY_MANNER_ALIPAY);
//                    } catch (ServiceException e) {
//                        e.printStackTrace();
//                    } catch (ServiceDaoException e) {
//                        e.printStackTrace();
//                    }
//
//                }
//            }
//
//        }
        return bRes;
    }

    @Override
    public Boolean setPayAt(String orderId,Long payAt) {
//        log.info("  orderId = "+orderId+"  payAt = "+payAt);
//        Order order = orderService.getOrderObjectByOrderId(new Object[]{orderId});
//        order.setPayAt(payAt);
//        Boolean updateResult =  dalBaseOrderService.update(order, () -> dao);
//        log.info(" updateResult = "+updateResult);
//        return updateResult;
        return false;
    }

    public static void main(String[] args){
        long a = System.currentTimeMillis();
        System.out.println(a);
        long aa = a + 60 * DateUtils.MILLIS_PER_DAY;
        System.out.println(" aa = "+aa);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        System.out.print(" bb = "+format.format(new Date(aa)));

    }

}
