/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Project;
import com.ptteng.common.skill.service.ProjectService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProjectServiceImpl
extends BaseDaoServiceImpl
implements ProjectService {
    private static final Log log = LogFactory.getLog(ProjectServiceImpl.class);

    public Long insert(Project project) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + project));
        if (project == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        project.setCreateAt(Long.valueOf(currentTimeMillis));
        project.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)project);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + project));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Project> insertList(List<Project> projectList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (projectList == null ? "null" : Integer.valueOf(projectList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(projectList)) {
            return new ArrayList<Project>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Project project : projectList) {
            project.setCreateAt(Long.valueOf(currentTimeMillis));
            project.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(projectList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + projectList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Project.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Project project) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (project == null ? "null" : project.getId())));
        boolean result = false;
        if (project == null) {
            return true;
        }
        project.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)project);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + project));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + project));
        }
        return result;
    }

    public boolean updateList(List<Project> projectList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (projectList == null ? "null" : Integer.valueOf(projectList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(projectList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Project project : projectList) {
            project.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(projectList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + projectList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + projectList.size()));
        return result;
    }

    public Project getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Project project = null;
        if (id == null) {
            return project;
        }
        try {
            project = (Project)this.dao.get(Project.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return project;
    }

    public List<Project> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List project = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Project>();
        }
        try {
            project = this.dao.getList(Project.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (project == null ? "null" : Integer.valueOf(project.size()))));
        return project;
    }

    public List<Long> getProjectIdsByGidOrderByCreateAt(Long gid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by gid,start,limit  : " + gid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProjectIdsByGidOrderByCreateAt", new Object[]{gid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by gid,start,limit)  : " + gid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProjectIdsByGidOrderByCreateAt(Long gid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by gid  : " + gid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getProjectIdsByGidOrderByCreateAt", new Object[]{gid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by gid)  : " + gid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getProjectIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProjectIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProjectIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getProjectIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getProjectIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

