package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Leaves;
import com.ptteng.common.skill.service.LeavesService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class LeavesServiceImpl extends BaseDaoServiceImpl implements LeavesService {



	private static final Log log = LogFactory.getLog(LeavesServiceImpl.class);




	@Override
	public Long insert(Leaves leaves)throws ServiceException, ServiceDaoException{



		log.info(" insert data : " + leaves);

		if (leaves == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		leaves.setCreateAt(currentTimeMillis);
		leaves.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(leaves);
		} catch (DaoException e) {
			log.error(" insert wrong : " + leaves);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

		return result;
	}


	@Override
	public List<Leaves> insertList(List<Leaves> leavesList)throws ServiceException, ServiceDaoException{



		log.info(" insert lists : " + (leavesList == null ? "null" : leavesList.size()));

		List<Leaves> resultList = null;

		if (CollectionUtils.isEmpty(leavesList)) {
			return new ArrayList<Leaves>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Leaves leaves : leavesList) {
			leaves.setCreateAt(currentTimeMillis);
			leaves.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Leaves>) dao.batchSave(leavesList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + leavesList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



	}


	@Override
	public boolean delete(Long id)throws ServiceException, ServiceDaoException{



		log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Leaves.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

	}


	@Override
	public boolean update(Leaves leaves)throws ServiceException, ServiceDaoException{



		log.info(" update data : " + (leaves == null ? "null" : leaves.getId()));

		boolean result = false;

		if (leaves == null) {
			return true;
		}

		leaves.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(leaves);
		} catch (DaoException e) {
			log.error(" update wrong : " + leaves);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" update data success : " + leaves);
		}
		return result;
	}


	@Override
	public boolean updateList(List<Leaves> leavesList)throws ServiceException, ServiceDaoException{


		log.info(" update lists : " + (leavesList == null ? "null" : leavesList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(leavesList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Leaves leaves : leavesList) {
			leaves.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(leavesList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + leavesList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + leavesList.size());

		return result;
	}


	@Override
	public Leaves getObjectById(Long id)throws ServiceException, ServiceDaoException{



		log.info(" get data : " + id);

		Leaves leaves = null;

		if (id == null) {
			return leaves;
		}

		try {
			leaves = (Leaves) dao.get(Leaves.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return leaves;
	}


	@Override
	public List<Leaves> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



		log.info(" get lists : " + (ids == null ? "null" : ids));

		List<Leaves> leaves = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Leaves>();
		}

		try {
			leaves = (List<Leaves>) dao.getList(Leaves.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (leaves == null ? "null" : leaves.size()));

		return leaves;
	}







	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getLeavesIdsByUidOrderByStartAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getLeavesIdsByUidOrderByStartAt", new Object[] { uid},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}





	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countLeavesIdsByUidOrderByStartAt(Long uid)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by uid  : " + uid );
		}
		Integer count=null;



		try {

			count = dao.count("getLeavesIdsByUidOrderByStartAt", new Object[] { uid});


		} catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}






	@Override
	public List<Long> getLeavesIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getLeavesIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	@Override
	public Integer countLeavesIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getLeavesIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getLeavesIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

