/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Card;
import com.ptteng.common.skill.service.CardService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CardServiceImpl
extends BaseDaoServiceImpl
implements CardService {
    private static final Log log = LogFactory.getLog(CardServiceImpl.class);

    public Long insert(Card card) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + card));
        if (card == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        card.setCreateAt(Long.valueOf(currentTimeMillis));
        card.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)card);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + card));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Card> insertList(List<Card> cardList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (cardList == null ? "null" : Integer.valueOf(cardList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(cardList)) {
            return new ArrayList<Card>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Card card : cardList) {
            card.setCreateAt(Long.valueOf(currentTimeMillis));
            card.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(cardList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + cardList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Card.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Card card) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (card == null ? "null" : card.getId())));
        boolean result = false;
        if (card == null) {
            return true;
        }
        card.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)card);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + card));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + card));
        }
        return result;
    }

    public boolean updateList(List<Card> cardList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (cardList == null ? "null" : Integer.valueOf(cardList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(cardList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Card card : cardList) {
            card.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(cardList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + cardList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + cardList.size()));
        return result;
    }

    public Card getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Card card = null;
        if (id == null) {
            return card;
        }
        try {
            card = (Card)this.dao.get(Card.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return card;
    }

    public List<Card> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List card = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Card>();
        }
        try {
            card = this.dao.getList(Card.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (card == null ? "null" : Integer.valueOf(card.size()))));
        return card;
    }

    public List<Long> getCardIdsByOwnerIdOrderByCreateAt(Integer ownerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by ownerId,start,limit  : " + ownerId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCardIdsByOwnerIdOrderByCreateAt", new Object[]{ownerId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by ownerId,start,limit)  : " + ownerId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getCardIdsByStatusAndOwnerIdOrderByCreateAt(Integer status, Integer ownerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by status,ownerId,start,limit  : " + status + " , " + ownerId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCardIdsByStatusAndOwnerIdOrderByCreateAt", new Object[]{status, ownerId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by status,ownerId,start,limit)  : " + status + " , " + ownerId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCardIdsByOwnerIdOrderByCreateAt(Integer ownerId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by ownerId  : " + ownerId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCardIdsByOwnerIdOrderByCreateAt", new Object[]{ownerId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by ownerId)  : " + ownerId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countCardIdsByStatusAndOwnerIdOrderByCreateAt(Integer status, Integer ownerId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by status,ownerId  : " + status + " , " + ownerId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCardIdsByStatusAndOwnerIdOrderByCreateAt", new Object[]{status, ownerId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by status,ownerId)  : " + status + " , " + ownerId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getCardIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCardIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCardIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCardIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCardIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

