

-- ----------------------------
-- Table structure for `user_article_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_article_relation`;
CREATE TABLE `user_article_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `aid` bigint(20) NOT NULL   COMMENT '日报ID',
    `uid` bigint(20) NOT NULL   COMMENT '用户ID',
    `type` int(11)    COMMENT '用户与日报关系 1-点赞 2-收藏',
    `whether` int(11)    COMMENT '关系状态 1-存在 2-撤销',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;








-- ----------------------------
-- Table structure for `user_skill_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_skill_relation`;
    CREATE TABLE `user_skill_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `sid` bigint(20) NOT NULL   COMMENT '技能ID',
    `uid` bigint(20) NOT NULL   COMMENT '用户ID',
    `degree` int(11)    COMMENT '技能熟练度',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;







-- ----------------------------
-- Table structure for `user_task_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_task_relation`;
CREATE TABLE `user_task_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `tid` bigint(20) NOT NULL   COMMENT '任务ID',
    `uid` bigint(20) NOT NULL   COMMENT '用户ID',
    `oid` bigint(20) NOT NULL   COMMENT '职业ID',
    `progress` int(2) NOT NULL   COMMENT '当前进度',
    `result_url` varchar(1000)    COMMENT '成果展示链接',
    `code_url` varchar(1000)    COMMENT '成果代码链接',
    `receive_at` bigint(20)    COMMENT '领取任务时间',
    `submit_at` bigint(20)    COMMENT '提交任务时间',
    `judge_uid` bigint(20)    COMMENT '审核者用户ID',
    `judge_remark` text    COMMENT '审核备注',
    `judge_at` bigint(20)    COMMENT '审核时间',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `sms`
-- ----------------------------
-- DROP TABLE IF EXISTS `sms`;
CREATE TABLE `sms` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `message` varchar(1000) NOT NULL  ,  
    `type` varchar(50) NOT NULL  ,  
    `mobile` varchar(30) NOT NULL  ,  
    `count` int   ,  
    `send_at` bigint NOT NULL  ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `nick` varchar(1000)   ,  
    `mobile` varchar(200) NOT NULL  ,  
    `pwd` varchar(1000) NOT NULL  ,  
    `sex` bigint   ,  
    `thumb` varchar(200)   ,  
    `sign` varchar(1000)   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_class_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_class_relation`;
CREATE TABLE `user_class_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `cid` bigint NOT NULL  ,  
    `swear` vachar(1000)   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `comment`
-- ----------------------------
-- DROP TABLE IF EXISTS `comment`;
CREATE TABLE `comment` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `did` bigint NOT NULL  ,  
    `comment` varchar(1000)   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `occupation`
-- ----------------------------
-- DROP TABLE IF EXISTS `occupation`;
CREATE TABLE `occupation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(200)   ,  
    `grade_count` bigint NOT NULL  ,  
    `class_count` bigint NOT NULL  ,  
    `user_count` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `article`
-- ----------------------------
-- DROP TABLE IF EXISTS `article`;
CREATE TABLE `article` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `cid` bigint NOT NULL  ,  
    `uid` bigint NOT NULL  ,  
    `type` varchar(200) NOT NULL  ,  
    `title` varchar(500)   ,  
    `content` varchar(1000)   ,  
    `reply` bigint   ,  
    `read` bigint   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `class`
-- ----------------------------
-- DROP TABLE IF EXISTS `class`;
CREATE TABLE `class` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(200) NOT NULL  ,  
    `oid` bigint NOT NULL  ,  
    `total` bigint NOT NULL  ,  
    `qq` bigint   ,  
    `content` varchar(1000)   ,  
    `grade` bigint NOT NULL  ,  
    `status` bigint NOT NULL  ,  
    `create_by` bigint NOT NULL  ,  
    `update_by` bigint NOT NULL  ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `user_score`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_score`;
CREATE TABLE `user_score` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `uid` bigint(20) NOT NULL   COMMENT '用户id',
    `score` bigint(20) NOT NULL   COMMENT '总积分',
    `comment` text    COMMENT '积分增减原由描述',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `leaves`
-- ----------------------------
-- DROP TABLE IF EXISTS `leaves`;
CREATE TABLE `leaves` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `uid` bigint(20) NOT NULL   COMMENT '用户id',
    `start_at` bigint(20) NOT NULL   COMMENT '请假时间',
    `end_at` bigint(20) NOT NULL   COMMENT '销假时间',
    `hours` int(50) NOT NULL   COMMENT '请假小时数',
    `comments` text NOT NULL   COMMENT '请假理由',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `constant`
-- ----------------------------
-- DROP TABLE IF EXISTS `constant`;
CREATE TABLE `constant` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `name` varchar(500)    COMMENT '用户ID',
    `value` varchar(2000)    COMMENT '日报id',
    `type` varchar(1000)    COMMENT '评论',
    `comments` varchar(2000)    COMMENT '备注',
    `create_by` bigint(20) NOT NULL   COMMENT '',
    `update_by` bigint(20) NOT NULL   COMMENT '',
    `update_at` bigint(20) NOT NULL   COMMENT '',
    `create_at` bigint(20) NOT NULL   COMMENT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `ctype`
-- ----------------------------
-- DROP TABLE IF EXISTS `ctype`;
CREATE TABLE `ctype` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'id',
    `title` varchar(50) NOT NULL   COMMENT '类型名称',
    `img` varchar(255)    COMMENT '图片链接',
    `description` varchar(255)    COMMENT '使用规则限制描述',
    `expire` int(8) NOT NULL   COMMENT '有效期',
    `status` int(2) NOT NULL   COMMENT '是否有效',
    `create_by` bigint NOT NULL   COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint    COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `card`
-- ----------------------------
-- DROP TABLE IF EXISTS `card`;
CREATE TABLE `card` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'id',
    `code` varchar(20) NOT NULL    COMMENT '卡券编号',
    `tid` bigint NOT NULL   COMMENT '类型id',
    `owner_id` bigint    COMMENT '持有者id',
    `assign_id` bigint    COMMENT '发放人id',
    `verification_id` bigint    COMMENT '核销人id',
    `status` int(2) NOT NULL   COMMENT '状态',
    `card_valid` int(2) NOT NULL   COMMENT '启用禁用状态',
    `assign_at` bigint    COMMENT '发放时间',
    `apply_at` bigint    COMMENT '申请使用时间',
    `verification_at` bigint    COMMENT '核销时间',
    `expire_at` bigint    COMMENT '过期时间',
    `create_by` bigint NOT NULL   COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint    COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





-- ----------------------------
-- Table structure for `clog`
-- ----------------------------
-- DROP TABLE IF EXISTS `clog`;
CREATE TABLE `clog` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'id',
    `cid` bigint NOT NULL   COMMENT '卡券id',
    `tid` bigint NOT NULL   COMMENT '类型id',
    `type` int(2) NOT NULL   COMMENT '操作',
    `admin_id` int(8)    COMMENT '管理员',
    `use_id` int(8)    COMMENT '使用人',
    `receive_id` int(8)    COMMENT '被使用人',
    `remark` VARCHAR(100)    COMMENT '备注',
    `create_by` bigint NOT NULL   COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint    COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_statistics`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_statistics`;
CREATE TABLE `user_statistics` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '关联用户ID',
    `card_used` int(10)    COMMENT '已使用卡券',
    `card_unused` int(10)    COMMENT '未使用卡券',
    `card_verified` int(10)    COMMENT '已核销卡券',
    `card_verifying` int(10)    COMMENT '核销中卡券',
    `card_cession` int(10)    COMMENT '已转让卡券',
    `card_expired` int(10)    COMMENT '已过期卡券',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;










