/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Leaves;
import com.ptteng.common.skill.service.LeavesService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LeavesServiceImpl
extends BaseDaoServiceImpl
implements LeavesService {
    private static final Log log = LogFactory.getLog(LeavesServiceImpl.class);

    public Long insert(Leaves leaves) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + leaves));
        if (leaves == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        leaves.setCreateAt(Long.valueOf(currentTimeMillis));
        leaves.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)leaves);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + leaves));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Leaves> insertList(List<Leaves> leavesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (leavesList == null ? "null" : Integer.valueOf(leavesList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(leavesList)) {
            return new ArrayList<Leaves>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Leaves leaves : leavesList) {
            leaves.setCreateAt(Long.valueOf(currentTimeMillis));
            leaves.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(leavesList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + leavesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Leaves.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Leaves leaves) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (leaves == null ? "null" : leaves.getId())));
        boolean result = false;
        if (leaves == null) {
            return true;
        }
        leaves.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)leaves);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + leaves));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + leaves));
        }
        return result;
    }

    public boolean updateList(List<Leaves> leavesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (leavesList == null ? "null" : Integer.valueOf(leavesList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(leavesList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Leaves leaves : leavesList) {
            leaves.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(leavesList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + leavesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + leavesList.size()));
        return result;
    }

    public Leaves getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Leaves leaves = null;
        if (id == null) {
            return leaves;
        }
        try {
            leaves = (Leaves)this.dao.get(Leaves.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return leaves;
    }

    public List<Leaves> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List leaves = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Leaves>();
        }
        try {
            leaves = this.dao.getList(Leaves.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (leaves == null ? "null" : Integer.valueOf(leaves.size()))));
        return leaves;
    }

    public List<Long> getLeavesIdsByUidOrderByStartAt(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLeavesIdsByUidOrderByStartAt", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countLeavesIdsByUidOrderByStartAt(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getLeavesIdsByUidOrderByStartAt", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getLeavesIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getLeavesIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countLeavesIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getLeavesIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getLeavesIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

