/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Order;
import com.ptteng.common.skill.service.OrderService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderServiceImpl
extends BaseDaoServiceImpl
implements OrderService {
    private static final Log log = LogFactory.getLog(OrderServiceImpl.class);

    public Long insert(Order order) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + order));
        if (order == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        order.setCreateAt(Long.valueOf(currentTimeMillis));
        order.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)order);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + order));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Order> insertList(List<Order> orderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (orderList == null ? "null" : Integer.valueOf(orderList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(orderList)) {
            return new ArrayList<Order>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Order order : orderList) {
            order.setCreateAt(Long.valueOf(currentTimeMillis));
            order.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(orderList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + orderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Order.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Order order) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (order == null ? "null" : order.getId())));
        boolean result = false;
        if (order == null) {
            return true;
        }
        order.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)order);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + order));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + order));
        }
        return result;
    }

    public boolean updateList(List<Order> orderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (orderList == null ? "null" : Integer.valueOf(orderList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(orderList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Order order : orderList) {
            order.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(orderList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + orderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + orderList.size()));
        return result;
    }

    public Order getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Order order = null;
        if (id == null) {
            return order;
        }
        try {
            order = (Order)this.dao.get(Order.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return order;
    }

    public Order getObjectByOrderId(String orderId) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + orderId));
        Order order = null;
        if (orderId == null) {
            return order;
        }
        try {
            Long id = (Long)this.dao.getMapping("getObjectByOrderId", new Object[]{orderId});
            log.info((Object)("the id =" + id));
            order = (Order)this.dao.get(Order.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + orderId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + orderId));
        return order;
    }

    public List<Order> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List order = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Order>();
        }
        try {
            order = this.dao.getList(Order.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (order == null ? "null" : Integer.valueOf(order.size()))));
        return order;
    }

    public List<Long> getOrderIdsByBuyer(Long buyer, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by buyer,start,limit  : " + buyer + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrderIdsByBuyer", new Object[]{buyer}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by buyer,start,limit)  : " + buyer + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getOrderIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by buyer,start,limit  : " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrderIdsByStatus", new Object[]{status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by buyer,start,limit)  : " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOrderIdsByBuyer(Long buyer) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by buyer  : " + buyer));
        }
        Integer count = null;
        try {
            count = this.dao.count("getOrderIdsByBuyer", new Object[]{buyer});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by buyer)  : " + buyer));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countOrderIdsByStatus(Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by buyer  : " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getOrderIdsByBuyer", new Object[]{status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by buyer)  : " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getOrderIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

