package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.ArticleTaskRelation;
import com.ptteng.common.skill.service.ArticleTaskRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ArticleTaskRelationServiceImpl extends BaseDaoServiceImpl implements ArticleTaskRelationService {

 

	private static final Log log = LogFactory.getLog(ArticleTaskRelationServiceImpl.class);



		   
		@Override
		public Long insert(ArticleTaskRelation articleTaskRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + articleTaskRelation);

		if (articleTaskRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		articleTaskRelation.setCreateAt(currentTimeMillis);
		articleTaskRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(articleTaskRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + articleTaskRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<ArticleTaskRelation> insertList(List<ArticleTaskRelation> articleTaskRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (articleTaskRelationList == null ? "null" : articleTaskRelationList.size()));
      
		List<ArticleTaskRelation> resultList = null;

		if (CollectionUtils.isEmpty(articleTaskRelationList)) {
			return new ArrayList<ArticleTaskRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ArticleTaskRelation articleTaskRelation : articleTaskRelationList) {
			articleTaskRelation.setCreateAt(currentTimeMillis);
			articleTaskRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<ArticleTaskRelation>) dao.batchSave(articleTaskRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + articleTaskRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(ArticleTaskRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(ArticleTaskRelation articleTaskRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (articleTaskRelation == null ? "null" : articleTaskRelation.getId()));

		boolean result = false;

		if (articleTaskRelation == null) {
			return true;
		}

		articleTaskRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(articleTaskRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + articleTaskRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + articleTaskRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<ArticleTaskRelation> articleTaskRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (articleTaskRelationList == null ? "null" : articleTaskRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(articleTaskRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ArticleTaskRelation articleTaskRelation : articleTaskRelationList) {
			articleTaskRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(articleTaskRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + articleTaskRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + articleTaskRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public ArticleTaskRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		ArticleTaskRelation articleTaskRelation = null;

		if (id == null) {
			return articleTaskRelation;
		}

		try {
			articleTaskRelation = (ArticleTaskRelation) dao.get(ArticleTaskRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return articleTaskRelation;		
		}	
		  
    	   
		@Override
		public List<ArticleTaskRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		

	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<ArticleTaskRelation> articleTaskRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<ArticleTaskRelation>();
		}

		try {
			articleTaskRelation = (List<ArticleTaskRelation>) dao.getList(ArticleTaskRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (articleTaskRelation == null ? "null" : articleTaskRelation.size()));
    
		return articleTaskRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getArticleTaskRelationIdsByDid(Long did,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by did,start,limit  : " + did+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getArticleTaskRelationIdsByDid", new Object[] { did},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by did,start,limit)  : " + did+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getTidsByDid(Long did, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by did,start,limit  : " + did+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getTidsByDid", new Object[] { did},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by tid,start,limit)  : " + did+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}

	@Override
	public List<Long> getDidsByTid(Long tid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by tid,start,limit  : " + tid+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getDidsByTid", new Object[] {tid},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by tid,start,limit)  : " + tid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	@Override
	public Integer countDidsByTid(Long tid) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" count ids by tid  : " + tid );
		}
		Integer count=null;



		try {

			count = dao.count("getDidsByTid", new Object[] { tid});


		} catch (DaoException e) {
			log.error(" count ids  wrong by tid)  : " + tid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;
	}


	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getArticleTaskRelationIdsByTid(Long tid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by tid,start,limit  : " + tid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getArticleTaskRelationIdsByTid", new Object[] { tid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by tid,start,limit)  : " + tid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getArticleTaskRelationIdByDidAndTid(Long did,Long tid)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by did,tid  : " + did+" , "+tid );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getArticleTaskRelationIdByDidAndTid", new Object[] {did,tid });
   } catch (DaoException e) {
			log.error(" get id wrong by did,tid  : " + did+" , "+tid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countArticleTaskRelationIdsByDid(Long did)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by did  : " + did );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getArticleTaskRelationIdsByDid", new Object[] { did});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by did)  : " + did );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countArticleTaskRelationIdsByTid(Long tid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by tid  : " + tid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getArticleTaskRelationIdsByTid", new Object[] { tid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by tid)  : " + tid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getArticleTaskRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getArticleTaskRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countArticleTaskRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getArticleTaskRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getArticleTaskRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

