package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Message;
import com.ptteng.common.skill.service.MessageService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class MessageServiceImpl extends BaseDaoServiceImpl implements MessageService {


    private static final Log log = LogFactory.getLog(MessageServiceImpl.class);


    @Override
    public Long insert(Message message) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + message);

        if (message == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        message.setCreateAt(currentTimeMillis);
        message.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(message);
        } catch (DaoException e) {
            log.error(" insert wrong : " + message);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Message> insertList(List<Message> messageList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (messageList == null ? "null" : messageList.size()));

        List<Message> resultList = null;

        if (CollectionUtils.isEmpty(messageList)) {
            return new ArrayList<Message>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Message message : messageList) {
            message.setCreateAt(currentTimeMillis);
            message.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Message>) dao.batchSave(messageList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + messageList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Message.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Message message) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (message == null ? "null" : message.getId()));

        boolean result = false;

        if (message == null) {
            return true;
        }

        message.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(message);
        } catch (DaoException e) {
            log.error(" update wrong : " + message);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + message);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Message> messageList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (messageList == null ? "null" : messageList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(messageList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Message message : messageList) {
            message.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(messageList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + messageList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + messageList.size());

        return result;
    }


    @Override
    public Message getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Message message = null;

        if (id == null) {
            return message;
        }

        try {
            message = (Message) dao.get(Message.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return message;
    }


    @Override
    public List<Message> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Message> message = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Message>();
        }

        try {
            message = (List<Message>) dao.getList(Message.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (message == null ? "null" : message.size()));

        return message;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getMessageIdsBySendIdAndStatus(Long sendId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by sendId,status,start,limit  : " + sendId + " , " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getMessageIdsBySendIdAndStatus", new Object[]{sendId, status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by sendId,status,start,limit)  : " + sendId + " , " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getMessageIdsByReceiveIdAndUnreadAndStatus(Long receiveId, Integer unread, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by receiveId,unread,status,start,limit  : " + receiveId + " , " + unread + " , " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getMessageIdsByReceiveIdAndUnreadAndStatus", new Object[]{receiveId, unread, status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by receiveId,unread,status,start,limit)  : " + receiveId + " , " + unread + " , " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getMessageIdsByReceiveIdAndUnreadAndStatusAndType(Long receiveId, Integer unread, Integer status, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by receiveId,unread,status,type,start,limit  : " + receiveId + " , " + unread + " , " + status + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getMessageIdsByReceiveIdAndUnreadAndStatusAndType", new Object[]{receiveId, unread, status, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by receiveId,unread,status,type,start,limit)  : " + receiveId + " , " + unread + " , " + status + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getMessageIdsByReceiveIdAndStatus(Long receiveId, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by receiveId,status,start,limit  : " + receiveId + " , " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getMessageIdsByReceiveIdAndStatus", new Object[]{receiveId, status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by receiveId,status,start,limit)  : " + receiveId + " , " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getMessageIdsByReceiveIdAndStatusAndType(Long receiveId, Integer status, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by receiveId,status,type,start,limit  : " + receiveId + " , " + status + " , " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getMessageIdsByReceiveIdAndStatusAndType", new Object[]{receiveId, status, type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by receiveId,status,type,start,limit)  : " + receiveId + " , " + status + " , " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countMessageIdsBySendIdAndStatus(Long sendId, Integer status) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by sendId,status  : " + sendId + " , " + status);
        }
        Integer count = null;


        try {

            count = dao.count("getMessageIdsBySendIdAndStatus", new Object[]{sendId, status});


        } catch (DaoException e) {
            log.error(" count ids  wrong by sendId,status)  : " + sendId + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countMessageIdsByReceiveIdAndStatus(Long receiveId, Integer status) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by receiveId,status  : " + receiveId + " , " + status);
        }
        Integer count = null;


        try {

            count = dao.count("getMessageIdsByReceiveIdAndStatus", new Object[]{receiveId, status});


        } catch (DaoException e) {
            log.error(" count ids  wrong by receiveId,status)  : " + receiveId + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getMessageIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getMessageIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countMessageIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getMessageIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getMessageIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public List<Long> getMessageIdsBySendIdAndStatusAndType(Long uid, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        log.info(" get ids   by sendId  ================== " + uid);
        List<Long> idList = null;
        try {
            idList = dao.getIdList("getMessageIdsBySendIdAndStatusAndType", new Object[]{uid,uid}, start, limit, false);
        } catch (DaoException e) {
            log.error(" ids by getMessageIdsBySendIdAndStatusAndType ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        return idList;
    }

    @Override
    public List<Long> getMessageIdsByReceiveIdAndStatusAndTypePrivate(Long uid, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        log.info(" get ids   by receiveId  ================== " + uid);
        List<Long> idList = null;
        try {
            idList = dao.getIdList("getMessageIdsByReceiveIdAndStatusAndTypePrivate", new Object[]{uid,uid}, start, limit, false);
        } catch (DaoException e) {
            log.error(" ids by getMessageIdsByReceiveIdAndStatusAndTypePrivate ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        return idList;
    }

    @Override
    public List<Long> getMessageIdsByReceiveIdAndSendId(Long uid, Long pid,Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        log.info(" get ids   by receiveId  ================== " + uid + "sendId" + pid);
        List<Long> idList = null;
        try {
            idList = dao.getIdList("getMessageIdsByReceiveIdAndSendId", new Object[]{uid, pid,uid, pid,pid,uid,pid,uid}, start, limit, false);
        } catch (DaoException e) {
            log.error(" getMessageIdsByReceiveIdAndSendId is error ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        return idList;
    }

    @Override
    public List<Long> getMessagesTodayUnixList(Long uid ,Long minTodayUnix,Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        log.info(" get ids   by receiveId  ================== " + uid + "sendId" + minTodayUnix);
        List<Long> idList = null;
        limit=500;
        try {
            idList = dao.getIdList("getMessagesTodayUnixList", new Object[]{ uid,minTodayUnix}, start, limit, false);
        } catch (DaoException e) {
            log.error(" getMessagesTodayUnixList is error ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        return idList;
    }

    @Override
    public Integer countMessagesBySendIdAndReceiveId(Long sendId, Long sreceiveId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by sendId,status  : " + sendId + " , " + sreceiveId);
        }
        Integer count = null;


        try {

            count = dao.count("countMessagesBySendIdAndReceiveId", new Object[]{sendId, sreceiveId});


        } catch (DaoException e) {
            log.error(" count ids  wrong by sendId,status)  : " + sendId + " , " + sreceiveId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }

}



