package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Clog;
import com.ptteng.common.skill.service.ClogService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ClogServiceImpl extends BaseDaoServiceImpl implements ClogService {

 

	private static final Log log = LogFactory.getLog(ClogServiceImpl.class);



		   
		@Override
		public Long insert(Clog clog)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + clog);

		if (clog == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		clog.setCreateAt(currentTimeMillis);
		clog.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(clog);
		} catch (DaoException e) {
			log.error(" insert wrong : " + clog);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Clog> insertList(List<Clog> clogList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (clogList == null ? "null" : clogList.size()));
      
		List<Clog> resultList = null;

		if (CollectionUtils.isEmpty(clogList)) {
			return new ArrayList<Clog>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Clog clog : clogList) {
			clog.setCreateAt(currentTimeMillis);
			clog.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Clog>) dao.batchSave(clogList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + clogList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Clog.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Clog clog)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (clog == null ? "null" : clog.getId()));

		boolean result = false;

		if (clog == null) {
			return true;
		}

		clog.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(clog);
		} catch (DaoException e) {
			log.error(" update wrong : " + clog);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + clog);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Clog> clogList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (clogList == null ? "null" : clogList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(clogList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Clog clog : clogList) {
			clog.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(clogList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + clogList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + clogList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Clog getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Clog clog = null;

		if (id == null) {
			return clog;
		}

		try {
			clog = (Clog) dao.get(Clog.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return clog;		
		}	
		  
    	   
		@Override
		public List<Clog> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Clog> clog = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Clog>();
		}

		try {
			clog = (List<Clog>) dao.getList(Clog.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (clog == null ? "null" : clog.size()));
    
		return clog;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getClogIdsByUseIdAndTypeOrderByCreateAt(Integer useId,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by useId,type,start,limit  : " + useId+" , "+type+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getClogIdsByUseIdAndTypeOrderByCreateAt", new Object[] { useId,type},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by useId,type,start,limit)  : " + useId+" , "+type+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getClogIdsByUseIdOrderByCreateAt(Integer useId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by useId,start,limit  : " + useId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getClogIdsByUseIdOrderByCreateAt", new Object[] { useId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by useId,start,limit)  : " + useId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countClogIdsByUseIdAndTypeOrderByCreateAt(Integer useId,Integer type)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by useId,type  : " + useId+" , "+type );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getClogIdsByUseIdAndTypeOrderByCreateAt", new Object[] { useId,type});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by useId,type)  : " + useId+" , "+type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countClogIdsByUseIdOrderByCreateAt(Integer useId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by useId  : " + useId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getClogIdsByUseIdOrderByCreateAt", new Object[] { useId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by useId)  : " + useId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getClogIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getClogIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countClogIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getClogIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getClogIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

