/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.UserClassRelation;
import com.ptteng.common.skill.service.UserClassRelationService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserClassRelationServiceImpl
extends BaseDaoServiceImpl
implements UserClassRelationService {
    private static final Log log = LogFactory.getLog(UserClassRelationServiceImpl.class);

    public Long insert(UserClassRelation userClassRelation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userClassRelation));
        if (userClassRelation == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userClassRelation.setCreateAt(Long.valueOf(currentTimeMillis));
        userClassRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userClassRelation);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userClassRelation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserClassRelation> insertList(List<UserClassRelation> userClassRelationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userClassRelationList == null ? "null" : Integer.valueOf(userClassRelationList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userClassRelationList)) {
            return new ArrayList<UserClassRelation>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserClassRelation userClassRelation : userClassRelationList) {
            userClassRelation.setCreateAt(Long.valueOf(currentTimeMillis));
            userClassRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userClassRelationList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userClassRelationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserClassRelation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserClassRelation userClassRelation) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userClassRelation == null ? "null" : userClassRelation.getId())));
        boolean result = false;
        if (userClassRelation == null) {
            return true;
        }
        userClassRelation.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userClassRelation);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userClassRelation));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userClassRelation));
        }
        return result;
    }

    public boolean updateList(List<UserClassRelation> userClassRelationList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userClassRelationList == null ? "null" : Integer.valueOf(userClassRelationList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userClassRelationList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserClassRelation userClassRelation : userClassRelationList) {
            userClassRelation.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userClassRelationList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userClassRelationList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userClassRelationList.size()));
        return result;
    }

    public UserClassRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserClassRelation userClassRelation = null;
        if (id == null) {
            return userClassRelation;
        }
        try {
            userClassRelation = (UserClassRelation)this.dao.get(UserClassRelation.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userClassRelation;
    }

    public List<UserClassRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userClassRelation = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserClassRelation>();
        }
        try {
            userClassRelation = this.dao.getList(UserClassRelation.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userClassRelation == null ? "null" : Integer.valueOf(userClassRelation.size()))));
        return userClassRelation;
    }

    public List<Long> getUserClassRelationIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserClassRelationIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getUserClassRelationIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,status : " + uid + " , " + status));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserClassRelationIdsByUidAndStatus", new Object[]{uid, status});
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status : " + uid + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + id));
        }
        return id;
    }

    public Integer countUserClassRelationIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserClassRelationIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Long getUserClassRelationIdByCidAndUid(Long cid, Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by cid,uid  : " + cid + " , " + uid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserClassRelationIdByCidAndUid", new Object[]{cid, uid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by cid,uid  : " + cid + " , " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getUserClassRelationIdByCidAndUidAndStatus(Long cid, Long uid, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by cid,uid,status : " + cid + " , " + uid + " , " + status));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserClassRelationIdByCidAndUidAndStatus", new Object[]{cid, uid, status});
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by cid,uid,status : " + cid + " , " + uid + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + id));
        }
        return id;
    }

    public List<Long> getUserClassRelationIdByOidAndUid(Long oid, Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by oid,uid  : " + oid + " , " + uid));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserClassRelationIdByOidAndUid", new Object[]{oid, uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by oid,uid  : " + oid + " , " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + idList));
        }
        return idList;
    }

    public List<Long> getUserClassRelationIdsByCid(Long cid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by cid,start,limit  : " + cid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserClassRelationIdsByCid", new Object[]{cid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by cid,start,limit)  : " + cid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserClassRelationIdsByCid(Long cid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by cid  : " + cid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserClassRelationIdsByCid", new Object[]{cid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by cid)  : " + cid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserClassRelationIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserClassRelationIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserClassRelationIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserClassRelationIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserClassRelationIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Map<Long, Map<Long, Long>> getUidNumRelationListByCids(List<Long> cids, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by cids,start,limit  : " + cids + " , " + start + " , " + limit));
        }
        HashMap<Long, Map<Long, Long>> cid_Map = new HashMap<Long, Map<Long, Long>>();
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            for (Long cid : cids) {
                HashMap<Long, Long> uid_num = new HashMap<Long, Long>();
                List idList = this.dao.getIdList("getUserClassRelationIdsByCid", new Object[]{cid}, start, limit, false);
                List<UserClassRelation> objects = this.getObjectsByIds(idList);
                for (UserClassRelation object : objects) {
                    uid_num.put(object.getUid(), object.getNum());
                }
                cid_Map.put(cid, uid_num);
            }
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by cids,start,limit)  : " + cids + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (cid_Map == null ? "null" : Integer.valueOf(cid_Map.size()))));
        }
        return cid_Map;
    }

    public Map<Long, Map<Long, String>> getUidSwearRelationListByCids(List<Long> cids, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by cids,start,limit  : " + cids + " , " + start + " , " + limit));
        }
        HashMap<Long, Map<Long, String>> cid_Map = new HashMap<Long, Map<Long, String>>();
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            for (Long cid : cids) {
                HashMap<Long, String> uid_swear = new HashMap<Long, String>();
                List idList = this.dao.getIdList("getUserClassRelationIdsByCid", new Object[]{cid}, start, limit, false);
                List<UserClassRelation> objects = this.getObjectsByIds(idList);
                for (UserClassRelation object : objects) {
                    uid_swear.put(object.getUid(), object.getSwear());
                }
                cid_Map.put(cid, uid_swear);
            }
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by cids,start,limit)  : " + cids + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (cid_Map == null ? "null" : Integer.valueOf(cid_Map.size()))));
        }
        return cid_Map;
    }

    public List<Long> getUserIdsByCid(Long cid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get userIDS   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserIdsByCidOfUserClassRelation", new Object[]{cid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get userIDS  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get userIDS success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }
}

