/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Classes;
import com.ptteng.common.skill.service.ClassesService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassesServiceImpl
extends BaseDaoServiceImpl
implements ClassesService {
    private static final Log log = LogFactory.getLog(ClassesServiceImpl.class);

    public Long insert(Classes classes) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + classes));
        if (classes == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        classes.setCreateAt(Long.valueOf(currentTimeMillis));
        classes.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)classes);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + classes));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Classes> insertList(List<Classes> classesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (classesList == null ? "null" : Integer.valueOf(classesList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(classesList)) {
            return new ArrayList<Classes>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Classes classes : classesList) {
            classes.setCreateAt(Long.valueOf(currentTimeMillis));
            classes.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(classesList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + classesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Classes.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Classes classes) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (classes == null ? "null" : classes.getId())));
        boolean result = false;
        if (classes == null) {
            return true;
        }
        classes.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)classes);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + classes));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + classes));
        }
        return result;
    }

    public boolean updateList(List<Classes> classesList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (classesList == null ? "null" : Integer.valueOf(classesList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(classesList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Classes classes : classesList) {
            classes.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(classesList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + classesList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + classesList.size()));
        return result;
    }

    public Classes getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Classes classes = null;
        if (id == null) {
            return classes;
        }
        try {
            classes = (Classes)this.dao.get(Classes.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return classes;
    }

    public List<Classes> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List classes = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Classes>();
        }
        try {
            classes = this.dao.getList(Classes.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (classes == null ? "null" : Integer.valueOf(classes.size()))));
        return classes;
    }

    public List<Long> getClassesIdsByOidAndGrade(Long oid, Long grade, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by oid,grade,start,limit  : " + oid + " , " + grade + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassesIdsByOidAndGrade", new Object[]{oid, grade}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by oid,grade,start,limit)  : " + oid + " , " + grade + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getClassesIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name  : " + name));
        }
        List ids = null;
        try {
            ids = this.dao.getIdList("getClassesIdsByName", new Object[]{name}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + ids));
        }
        return ids;
    }

    public List<Long> getClassesIdsByOid(Long oid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by oid,start,limit  : " + oid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassesIdsByOid", new Object[]{oid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by oid,start,limit)  : " + oid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getClassesIdsByType(String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by type,start,limit  : " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassesIdsByType", new Object[]{type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by type,start,limit)  : " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getClassesIdsByOidAndName(Long oid, String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by oid,name,start,limit  : " + oid + " , " + name + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassesIdsByOidAndName", new Object[]{oid, name}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by oid,name,start,limit  : " + oid + " , " + name + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getClassesIdsByOidAndNameAndType(Long oid, String name, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by oid,name,type,start,limit  : " + oid + " , " + name + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassesIdsByOidAndNameAndType", new Object[]{oid, name, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by oid,name,type,start,limit  : " + oid + " , " + name + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getClassesIdsByOidAndType(Long oid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by oid,type,start,limit  : " + oid + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassesIdsByOidAndType", new Object[]{oid, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by type,name,start,limit  : " + oid + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getClassesIdsByTypeAndName(String type, String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by type,name,start,limit  : " + type + " , " + name + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassesIdsByTypeAndName", new Object[]{type, name}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by type,name,start,limit  : " + type + " , " + name + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countClassesIdsByOidAndGrade(Long oid, Long grade) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by oid,grade  : " + oid + " , " + grade));
        }
        Integer count = null;
        try {
            count = this.dao.count("getClassesIdsByOidAndGrade", new Object[]{oid, grade});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by oid,grade)  : " + oid + " , " + grade));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countClassesIdsByOid(Long oid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by oid  : " + oid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getClassesIdsByOid", new Object[]{oid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by oid)  : " + oid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countClassesIdsByType(String type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by type  : " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getClassesIdsByType", new Object[]{type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by type  : " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getClassesIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getClassesIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countClassesIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getClassesIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getClassesIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public List<Long> getClassesIdsbyOccupation(Long oid, Long start, Long limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by oid,oid  : " + oid + " , start " + start + " , limit " + limit));
        }
        List classesIdList = null;
        try {
            classesIdList = this.dao.getIdList("getClassesIdsbyOccupation", new Object[]{oid, start, limit}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by oid,oid  : " + oid + " , start " + start + " , limit " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get classesID success : " + classesIdList));
        }
        return classesIdList;
    }

    public List<Long> getClassesIdsbyOccupationAndType(Long oid, String type, Long start, Long limit, Integer classesStart, Integer classesSize) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by oid,type,oid  : " + oid + " , type " + type + " start " + start + " , limit " + limit));
        }
        List classesIdList = null;
        try {
            classesIdList = this.dao.getIdList("getClassesIdsbyOccupationAndType", new Object[]{oid, start, limit, type}, classesStart, classesSize, false);
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by oid,oid  : " + oid + " , type " + type + " start " + start + " , limit " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get classesID success : " + classesIdList));
        }
        return classesIdList;
    }
}

