/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Article;
import com.ptteng.common.skill.service.ArticleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArticleServiceImpl
extends BaseDaoServiceImpl
implements ArticleService {
    private static final Log log = LogFactory.getLog(ArticleServiceImpl.class);

    public Long insert(Article article) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + article));
        if (article == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        article.setCreateAt(Long.valueOf(currentTimeMillis));
        article.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)article);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + article));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Article> insertList(List<Article> articleList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (articleList == null ? "null" : Integer.valueOf(articleList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(articleList)) {
            return new ArrayList<Article>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Article article : articleList) {
            article.setCreateAt(Long.valueOf(currentTimeMillis));
            article.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(articleList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + articleList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Article.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Article article) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (article == null ? "null" : article.getId())));
        boolean result = false;
        if (article == null) {
            return true;
        }
        article.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)article);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + article));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + article));
        }
        return result;
    }

    public boolean updateList(List<Article> articleList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (articleList == null ? "null" : Integer.valueOf(articleList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(articleList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Article article : articleList) {
            article.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(articleList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + articleList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + articleList.size()));
        return result;
    }

    public Article getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Article article = null;
        if (id == null) {
            return article;
        }
        try {
            article = (Article)this.dao.get(Article.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return article;
    }

    public List<Article> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List article = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Article>();
        }
        try {
            article = this.dao.getList(Article.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (article == null ? "null" : Integer.valueOf(article.size()))));
        return article;
    }

    public List<Long> getArticleIdsByCidAndType(Long cid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by cid,type,start,limit  : " + cid + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getArticleIdsByCidAndType", new Object[]{cid, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by cid,type,start,limit)  : " + cid + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getArticleIdsByUidAndType(Long uid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,type,start,limit  : " + uid + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getArticleIdsByUidAndType", new Object[]{uid, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by cid,type,start,limit)  : " + uid + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer counttArticleIdsByUidAndType(Long uid, String type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,type  : " + uid + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getArticleIdsByUidAndType", new Object[]{uid, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,type)  : " + uid + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countArticleIdsByCidAndType(Long cid, String type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by cid,type  : " + cid + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getArticleIdsByCidAndType", new Object[]{cid, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by cid,type)  : " + cid + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getArticleIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getArticleIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countArticleIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getArticleIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getArticleIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long getLastArticleIdByUidAndCid(Long uid, Long cid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get lastArticleId by uid , cid  : " + uid + " , " + cid));
        }
        Long articleId = null;
        List articleIds = null;
        List articleIdList = null;
        try {
            articleIds = this.dao.getIdList("getArticleIdsByUidAndCid", new Object[]{uid, cid}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
            Long id = (Long)articleIds.get(0);
            Article article = this.getObjectById(id);
            Long dailyTime = article.getDailyTime();
            articleIdList = this.dao.getIdList("getArticlrIdsByUidAndCidAndDailyTime", new Object[]{uid, cid, dailyTime}, Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), false);
            articleId = (Long)articleIdList.get(0);
        }
        catch (DaoException e) {
            log.error((Object)(" get lastArticleId wrong by uid , cid)  : " + uid + " , " + cid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get lastArticleId : " + articleId));
        }
        return articleId;
    }

    public List<Long> getArticleIdByUidAndCid(Long uid, Long cid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get articleId by uid , cid  : " + uid + " , " + cid));
        }
        Object articleId = null;
        List articleIds = null;
        Object articleIdList = null;
        try {
            articleIds = this.dao.getIdList("getArticleIdsByUidAndCid", new Object[]{uid, cid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get articleId wrong by uid , cid)  : " + uid + " , " + cid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get articleId : " + articleId));
        }
        return articleIds;
    }

    public List<Long> getArticleIdsByOidAndType(Long oid, String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by cid,type,start,limit  : " + oid + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getArticleIdsByOidAndType", new Object[]{oid, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by oid,type,start,limit)  : " + oid + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countArticleIdsByOidAndType(Long oid, String type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by oid,type  : " + oid + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getArticleIdsByOidAndType", new Object[]{oid, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by oid,type)  : " + oid + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }
}

