package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.UserDocumentRelation;
import com.ptteng.common.skill.service.UserDocumentRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserDocumentRelationServiceImpl extends BaseDaoServiceImpl implements UserDocumentRelationService {

 

	private static final Log log = LogFactory.getLog(UserDocumentRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserDocumentRelation userDocumentRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userDocumentRelation);

		if (userDocumentRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userDocumentRelation.setCreateAt(currentTimeMillis);
		userDocumentRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userDocumentRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userDocumentRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserDocumentRelation> insertList(List<UserDocumentRelation> userDocumentRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userDocumentRelationList == null ? "null" : userDocumentRelationList.size()));
      
		List<UserDocumentRelation> resultList = null;

		if (CollectionUtils.isEmpty(userDocumentRelationList)) {
			return new ArrayList<UserDocumentRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserDocumentRelation userDocumentRelation : userDocumentRelationList) {
			userDocumentRelation.setCreateAt(currentTimeMillis);
			userDocumentRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserDocumentRelation>) dao.batchSave(userDocumentRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userDocumentRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserDocumentRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserDocumentRelation userDocumentRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userDocumentRelation == null ? "null" : userDocumentRelation.getId()));

		boolean result = false;

		if (userDocumentRelation == null) {
			return true;
		}

		userDocumentRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userDocumentRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userDocumentRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userDocumentRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserDocumentRelation> userDocumentRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userDocumentRelationList == null ? "null" : userDocumentRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userDocumentRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserDocumentRelation userDocumentRelation : userDocumentRelationList) {
			userDocumentRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userDocumentRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userDocumentRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userDocumentRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserDocumentRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserDocumentRelation userDocumentRelation = null;

		if (id == null) {
			return userDocumentRelation;
		}

		try {
			userDocumentRelation = (UserDocumentRelation) dao.get(UserDocumentRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userDocumentRelation;		
		}	
		  
    	   
		@Override
		public List<UserDocumentRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserDocumentRelation> userDocumentRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserDocumentRelation>();
		}

		try {
			userDocumentRelation = (List<UserDocumentRelation>) dao.getList(UserDocumentRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userDocumentRelation == null ? "null" : userDocumentRelation.size()));
    
		return userDocumentRelation;	
		}	
		  
    	
		
	
	
			
			
		
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public List<Long>  getUserDocumentRelationIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserDocumentRelationIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}

	@Override
	public List<Long> getUserDocumentRelationIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by uid,status,start,limit  : " + uid+" , "+status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserDocumentRelationIdsByUidAndStatus", new Object[] { uid,status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uid,status,start,limit  : " + uid+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}

	@Override
	public List<Long> getUserDocumentRelationIdsByUidAndStatusAndWhether(Long uid, Integer type, Integer status, Integer whether, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		log.info(" get ids by uid,status,whether,start,limit  : " + uid+" , "+status+" , " + whether + " , "+start+" , "+limit );

	List<Long> idList = null;

	// TODO 参数检查!

	if (start == null) {
		start = 0;
	}

	if (limit == null) {
		limit = Integer.MAX_VALUE;
	}

	try {
		idList = dao.getIdList("getUserDocumentRelationIdsByUidAndStatusAndWhether", new Object[] { uid,type,status,whether},start,limit, false);


	} catch (DaoException e) {
		log.error(" get ids  wrong by uid,status,start,limit  : " + uid+" , "+status+" , "+start+" , "+limit );
		log.error(e);
		e.printStackTrace();
		throw new ServiceDaoException(e);
	}
	if(log.isInfoEnabled()){
		log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
	}
	return idList;
	}

	@Override
	public Integer countUserDocumentRelationIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {
		if (log.isInfoEnabled()) {
			log.info(" count ids by uid and status  : " + uid+","+status);
		}
		Integer count = null;


		try {

			count = dao.count("getUserDocumentRelationIdsByUidAndStatus", new Object[]{uid,status});


		} catch (DaoException e) {
			log.error(" count ids  wrong by uid and status  : " + uid+","+status);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  success : " + count);
		}
		return count;
	}

	@Override
	public Integer countUserDocumentRelationIdsByUidAndStatusAndWhether(Long uid, Integer type, Integer status, Integer whether) throws ServiceException, ServiceDaoException {
		if (log.isInfoEnabled()) {
			log.info(" count ids by uid and status and whether : " + uid+","+status+" , "+whether);
		}
		Integer count = null;


		try {

			count = dao.count("getUserDocumentRelationIdsByUidAndStatusAndWhether", new Object[]{uid,type,status,whether});


		} catch (DaoException e) {
			log.error(" count ids  wrong by uid and status and whether : " + uid+","+status+" , "+whether);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  success : " + count);
		}
		return count;
	}

	@Override
	public List<Long> getUserDocumentRelationIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by uid,type,start,limit  : " + uid+" , "+type+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserDocumentRelationIdsByUidAndType", new Object[] { uid,type},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


	
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public List<Long>  getUserDocumentRelationIdsByDocumentId(Long documentId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by documentId,start,limit  : " + documentId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserDocumentRelationIdsByDocumentId", new Object[] { documentId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by documentId,start,limit)  : " + documentId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public Long  getUserDocumentRelationIdByUidAndDocumentId(Long uid,Long documentId)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by uid,documentId  : " + uid+" , "+documentId );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getUserDocumentRelationIdByUidAndDocumentId", new Object[] {uid,documentId });
   } catch (DaoException e) {
			log.error(" get id wrong by uid,documentId  : " + uid+" , "+documentId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}

	@Override
	public Long getUserDocumentRelationIdByUidAndDocumentIdAndStatus(Long uid, Long documentId, Integer status) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get id by uid,documentId,status  : " + uid+" , "+documentId+" , "+status );
		}
		Long id = null;

		// TODO 参数检查!

		try {



			id = (Long) dao.getMapping("getUserDocumentRelationIdByUidAndDocumentIdAndStatus", new Object[] {uid,documentId,status });
		} catch (DaoException e) {
			log.error(" get id wrong by uid,documentId,status  : " + uid+" , "+documentId+" , "+status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;
	}

	@Override
	public Long getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether(Long uid, Long documentId, Integer status, Integer whether) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get id by uid,documentId,status,whether  : " + uid+" , "+documentId+" , "+status+" , "+whether );
		}
		Long id = null;

		// TODO 参数检查!

		try {

			id = (Long) dao.getMapping("getUserDocumentRelationIdByUidAndDocumentIdAndStatusAndWhether", new Object[] {uid,documentId,status,whether });
		} catch (DaoException e) {
			log.error(" get id wrong by uid,documentId,status,whether  : " + uid+" , "+documentId+" , "+status+" , "+whether);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get id success : " + id);
		}
		return id;
	}


	
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public Integer  countUserDocumentRelationIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserDocumentRelationIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		
//
//@param 
//@return 
//@throws ServiceException
//@throws ServiceDaoException
	 
	 @Override
	public Integer  countUserDocumentRelationIdsByDocumentId(Long documentId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by documentId  : " + documentId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserDocumentRelationIdsByDocumentId", new Object[] { documentId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by documentId)  : " + documentId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserDocumentRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserDocumentRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserDocumentRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserDocumentRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserDocumentRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

